/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.Objects;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;

public enum TestCaseKind implements Internationalizable
{
    STANDARD,
    GHERKIN,
    KEYWORD,
    EXPLORATORY;


    public boolean isScripted() {
        return this.equals((Object)GHERKIN);
    }

    public String getI18nKey() {
        return "test-case.format." + this.name().toLowerCase();
    }

    public static TestCaseKind fromLeftJoinIds(Long scriptedTestCaseId, Long keywordTestCaseId, Long exploratoryTestCaseId) {
        boolean isGherkin = Objects.nonNull(scriptedTestCaseId);
        boolean isKeyword = Objects.nonNull(keywordTestCaseId);
        boolean isExploratory = Objects.nonNull(exploratoryTestCaseId);
        if (isGherkin) {
            return GHERKIN;
        }
        if (isKeyword) {
            return KEYWORD;
        }
        if (isExploratory) {
            return EXPLORATORY;
        }
        return STANDARD;
    }

    public static TestCaseKind fromTestCase(TestCase testCase) {
        GetKindTestCaseVisitor visitor = new GetKindTestCaseVisitor();
        testCase.accept(visitor);
        return visitor.getKind();
    }
}

