/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;

public final class TestCaseFactory {
    private TestCaseFactory() {
    }

    public static TestCase getTestCase(String testCaseKindAsString, String testCaseName) {
        TestCase testCase;
        TestCaseKind testCaseKind = TestCaseKind.valueOf(testCaseKindAsString);
        switch (testCaseKind) {
            case STANDARD: {
                testCase = new TestCase();
                testCase.setName(testCaseName);
                break;
            }
            case KEYWORD: {
                testCase = new KeywordTestCase();
                testCase.setName(testCaseName);
                break;
            }
            case GHERKIN: {
                testCase = new ScriptedTestCase(testCaseName);
                break;
            }
            case EXPLORATORY: {
                testCase = new ExploratoryTestCase();
                testCase.setName(testCaseName);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Kind " + testCaseKind.name() + " is not supported by the TestCaseFactory.");
            }
        }
        return testCase;
    }
}

