/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.TestCase;

@Entity
@Table(name="TEST_AUTOMATION_CANDIDATE")
public class TestAutomationCandidate
implements Identified {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_automation_candidate_test_automation_candidate_id_seq")
    @SequenceGenerator(name="test_automation_candidate_test_automation_candidate_id_seq", sequenceName="test_automation_candidate_test_automation_candidate_id_seq", allocationSize=30)
    @Column(name="TEST_AUTOMATION_CANDIDATE_ID")
    private Long id;
    @NotNull
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="TEST_CASE_ID", referencedColumnName="TCLN_ID", unique=true, nullable=false)
    private TestCase testCase;
    @NotNull
    private Integer priorityScore;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date evaluatedOn;
    @NotNull
    @Size(max=100)
    private @NotNull @Size(max=100) String evaluatedBy;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private SuggestionStatus suggestionStatus;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date decidedOn;
    @Size(max=100)
    private @Size(max=100) String decidedBy;
    private Integer decidedPriority;

    public TestAutomationCandidate() {
        this.suggestionStatus = SuggestionStatus.SUGGESTED;
    }

    public TestAutomationCandidate(TestCase testCase) {
        this.testCase = testCase;
        this.suggestionStatus = SuggestionStatus.SUGGESTED;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public Integer getPriorityScore() {
        return this.priorityScore;
    }

    public void setPriorityScore(Integer priorityScore) {
        this.priorityScore = priorityScore;
    }

    public Date getEvaluatedOn() {
        return this.evaluatedOn;
    }

    public void setEvaluatedOn(Date evaluatedOn) {
        this.evaluatedOn = evaluatedOn;
    }

    public String getEvaluatedBy() {
        return this.evaluatedBy;
    }

    public void setEvaluatedBy(String evaluatedBy) {
        this.evaluatedBy = evaluatedBy;
    }

    public SuggestionStatus getSuggestionStatus() {
        return this.suggestionStatus;
    }

    public void setSuggestionStatus(SuggestionStatus suggestionStatus) {
        this.suggestionStatus = suggestionStatus;
    }

    public Date getDecidedOn() {
        return this.decidedOn;
    }

    public void setDecidedOn(Date decidedOn) {
        this.decidedOn = decidedOn;
    }

    public String getDecidedBy() {
        return this.decidedBy;
    }

    public Integer getDecidedPriority() {
        return this.decidedPriority;
    }

    public void setDecidedPriority(Integer decidedPriority) {
        this.decidedPriority = decidedPriority;
    }

    public void setDecidedBy(String decidedBy) {
        this.decidedBy = decidedBy;
    }

    public static enum SuggestionStatus {
        SUGGESTED,
        APPROVED,
        REJECTED;

    }
}

