/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import java.util.List;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

public class ParameterNameInStepUpdater
implements TestStepVisitor {
    private String oldParamName;
    private String newParamName;

    public ParameterNameInStepUpdater(String oldParamName, String newParamName) {
        this.oldParamName = oldParamName;
        this.newParamName = newParamName;
    }

    private String replace(String content) {
        return content.replace(Parameter.getParamStringAsUsedInStandardTestCase(this.oldParamName), Parameter.getParamStringAsUsedInStandardTestCase(this.newParamName));
    }

    @Override
    public void visit(ActionTestStep visited) {
        if (visited.getAction() != null) {
            visited.setAction(this.replace(visited.getAction()));
        }
        if (visited.getExpectedResult() != null) {
            visited.setExpectedResult(this.replace(visited.getExpectedResult()));
        }
    }

    @Override
    public void visit(CallTestStep visited) {
    }

    @Override
    public void visit(KeywordTestStep visited) {
        List<ActionWordParameterValue> paramValues = visited.getParamValues();
        String oldMatchingParamValue = Parameter.getParamStringAsUsedInKeywordTestCase(this.oldParamName);
        String newMatchingParamValue = Parameter.getParamStringAsUsedInKeywordTestCase(this.newParamName);
        if (paramValues != null) {
            for (ActionWordParameterValue paramValue : paramValues) {
                String currentValue = paramValue.getValue();
                if (!oldMatchingParamValue.equals(currentValue)) continue;
                paramValue.setValue(newMatchingParamValue);
            }
        }
    }
}

