/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.text.StringEscapeUtils;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.actionword.ConsumerForActionWordFragmentVisitor;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordFragment;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.bdd.ActionWordParameterValue;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TEST_STEP_ID")
public class KeywordTestStep
extends TestStep {
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="KEYWORD")
    private Keyword keyword;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ACTION_WORD_ID")
    private ActionWord actionWord;
    @NotNull
    @OneToMany(mappedBy="keywordTestStep", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ActionWordParameterValue> paramValues = new ArrayList<ActionWordParameterValue>();
    @Lob
    @Column(name="DATATABLE")
    @JdbcTypeCode(value=-1)
    private String datatable = "";
    @Lob
    @Column(name="DOCSTRING")
    @JdbcTypeCode(value=-1)
    private String docstring = "";
    @Lob
    @Column(name="COMMENT")
    @JdbcTypeCode(value=-1)
    private String comment = "";
    @Transient
    private boolean hasTCParam = false;

    public KeywordTestStep() {
    }

    public KeywordTestStep(Keyword paramKeyword, ActionWord paramActionWord) {
        if (paramKeyword == null) {
            throw new IllegalArgumentException("Keyword cannot be null.");
        }
        if (paramActionWord == null) {
            throw new IllegalArgumentException("Action word cannot be null.");
        }
        this.keyword = paramKeyword;
        this.actionWord = paramActionWord;
    }

    @Override
    public TestStep createCopy() {
        KeywordTestStep copied = new KeywordTestStep(this.getKeyword(), this.getActionWord());
        this.copyTestStepParamValues(copied);
        this.copyTestStepDetails(copied);
        copied.setTestCase(this.getTestCase());
        return copied;
    }

    private void copyTestStepParamValues(KeywordTestStep copied) {
        for (ActionWordParameterValue sourceParameterValue : this.getParamValues()) {
            String valueOfTargetParamValue = sourceParameterValue.getValue();
            if ("\"\"".equals(valueOfTargetParamValue)) {
                valueOfTargetParamValue = "";
            }
            ActionWordParameterValue newValue = new ActionWordParameterValue(valueOfTargetParamValue);
            newValue.setActionWordParam(sourceParameterValue.getActionWordParam());
            newValue.setKeywordTestStep(copied);
            copied.addParamValues(newValue);
        }
    }

    private void copyTestStepDetails(KeywordTestStep copied) {
        copied.setDatatable(this.getDatatable());
        copied.setDocstring(this.getDocstring());
        copied.setComment(this.getComment());
    }

    @Override
    public void accept(TestStepVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<ExecutionStep> createExecutionSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        ArrayList<ExecutionStep> res = new ArrayList<ExecutionStep>(1);
        ExecutionStep executionStep = new ExecutionStep(this, dataset, messageSource, locale);
        res.add(executionStep);
        return res;
    }

    public String writeTestStepActionWordScript(boolean escapeArrows, boolean wrapParameterValuesWithDoubleQuotes) {
        ActionWord aw = this.getActionWord();
        List<ActionWordFragment> fragments = aw.getFragments();
        List<ActionWordParameterValue> values = this.getParamValues();
        return this.generateStepScriptFromActionWordFragments(fragments, values, escapeArrows, wrapParameterValuesWithDoubleQuotes);
    }

    private String generateStepScriptFromActionWordFragments(List<ActionWordFragment> fragments, List<ActionWordParameterValue> paramValues, boolean escapeArrows, boolean wrapParameterValuesWithDoubleQuotes) {
        StringBuilder stepBuilder = new StringBuilder();
        Consumer<ActionWordParameter> consumer = parameter -> this.appendParamValueToGenerateScript((ActionWordParameter)parameter, paramValues, stepBuilder, escapeArrows, wrapParameterValuesWithDoubleQuotes);
        ConsumerForActionWordFragmentVisitor visitor = new ConsumerForActionWordFragmentVisitor(consumer, stepBuilder);
        for (ActionWordFragment fragment : fragments) {
            fragment.accept(visitor);
        }
        return stepBuilder.toString();
    }

    private void appendParamValueToGenerateScript(ActionWordParameter param, List<ActionWordParameterValue> paramValues, StringBuilder stepBuilder, boolean escapeArrows, boolean wrapParameterValuesWithDoubleQuotes) {
        Optional<ActionWordParameterValue> paramValue = paramValues.stream().filter(pv -> pv.getActionWordParam() != null && pv.getActionWordParam().getId().equals(param.getId())).findAny();
        paramValue.ifPresent(actionWordParameterValue -> this.updateBuilderWithParamValue(stepBuilder, (ActionWordParameterValue)actionWordParameterValue, escapeArrows, wrapParameterValuesWithDoubleQuotes));
    }

    private void updateBuilderWithParamValue(StringBuilder builder, ActionWordParameterValue actionWordParameterValue, boolean escapeArrows, boolean wrapParameterValuesWithDoubleQuotes) {
        String paramValue = actionWordParameterValue.getValue();
        if ("\"\"".equals(paramValue)) {
            builder.append(paramValue);
            return;
        }
        if (actionWordParameterValue.isLinkedToTestCaseParam()) {
            this.hasTCParam = true;
            if (escapeArrows) {
                String replaceHTMLCharactersStr = StringEscapeUtils.escapeHtml4((String)paramValue);
                builder.append(replaceHTMLCharactersStr);
            } else {
                builder.append(paramValue);
            }
        } else if (wrapParameterValuesWithDoubleQuotes) {
            String updatedParamValue = ActionWordUtil.wrapWithDoubleQuotes(paramValue);
            builder.append(updatedParamValue);
        } else {
            String updatedParamValue = ActionWordUtil.updateNumberValue(paramValue);
            builder.append(updatedParamValue);
        }
    }

    public boolean hasTCParam() {
        return this.hasTCParam;
    }

    @Override
    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        if (!TestCaseKind.KEYWORD.equals((Object)testCase.getKind())) {
            throw new IllegalArgumentException("Cannot add a Keyword Test Step outside a Keyword Test Case");
        }
        super.setTestCase(testCase);
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public ActionWord getActionWord() {
        return this.actionWord;
    }

    public void setKeyword(Keyword keyword) {
        this.keyword = keyword;
    }

    public void setActionWord(ActionWord actionWord) {
        this.actionWord = actionWord;
    }

    public List<ActionWordParameterValue> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(List<ActionWordParameterValue> paramValues) {
        this.paramValues = paramValues;
    }

    public void addParamValues(ActionWordParameterValue value) {
        this.paramValues.add(value);
    }

    public String getDatatable() {
        return this.datatable;
    }

    public void setDatatable(String datatable) {
        this.datatable = datatable;
    }

    public String getDocstring() {
        return this.docstring;
    }

    public void setDocstring(String docstring) {
        this.docstring = docstring;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

