/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TEST_STEP_ID")
public class CallTestStep
extends TestStep {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="CALLED_TEST_CASE_ID")
    private TestCase calledTestCase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CALLED_DATASET")
    private Dataset calledDataset;
    @Column(name="DELEGATE_PARAMETER_VALUES")
    private boolean delegateParameterValues = false;

    @Override
    public CallTestStep createCopy() {
        CallTestStep copy = new CallTestStep();
        copy.calledDataset = this.calledDataset;
        copy.calledTestCase = this.calledTestCase;
        copy.delegateParameterValues = this.isDelegateParameterValues();
        copy.setTestCase(this.getTestCase());
        return copy;
    }

    @Override
    public void accept(TestStepVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        if (!TestCaseKind.STANDARD.equals((Object)testCase.getKind())) {
            throw new IllegalArgumentException("Cannot add a Call Test Step outside a Test Case");
        }
        super.setTestCase(testCase);
    }

    public void setCalledTestCase(TestCase calledTestCase) {
        this.calledTestCase = calledTestCase;
    }

    public TestCase getCalledTestCase() {
        return this.calledTestCase;
    }

    public Dataset getCalledDataset() {
        return this.calledDataset;
    }

    public void setCalledDataset(Dataset calledDataset) {
        if (calledDataset != null && !this.calledTestCase.getDatasets().contains(calledDataset)) {
            throw new IllegalArgumentException("attempted to bind to a call step a dataset that doesn't belong to the called test case");
        }
        this.calledDataset = calledDataset;
    }

    public boolean isDelegateParameterValues() {
        return this.delegateParameterValues;
    }

    public void setDelegateParameterValues(boolean delegateParameterValues) {
        this.delegateParameterValues = delegateParameterValues;
    }

    public ParameterAssignationMode getParameterAssignationMode() {
        if (this.calledDataset != null) {
            return ParameterAssignationMode.CALLED_DATASET;
        }
        if (this.delegateParameterValues) {
            return ParameterAssignationMode.DELEGATE;
        }
        return ParameterAssignationMode.NOTHING;
    }

    @Override
    public List<ExecutionStep> createExecutionSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        List<TestStep> testSteps = this.getCalledTestCase().getSteps();
        ArrayList<ExecutionStep> returnList = new ArrayList<ExecutionStep>(testSteps.size());
        Dataset effective = switch (this.getParameterAssignationMode()) {
            case ParameterAssignationMode.CALLED_DATASET -> this.calledDataset;
            case ParameterAssignationMode.DELEGATE -> dataset;
            case ParameterAssignationMode.NOTHING -> null;
            default -> dataset;
        };
        for (TestStep testStep : testSteps) {
            returnList.addAll(testStep.createExecutionSteps(effective, null, null));
        }
        return returnList;
    }
}

