/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AnalysisStatus;

@Entity
@Table(name="TEST_CANDIDATE_ANALYSIS")
public class TestCandidateAnalysis
implements Identified {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_candidate_analysis_test_candidate_analysis_id_seq")
    @SequenceGenerator(name="test_candidate_analysis_test_candidate_analysis_id_seq", sequenceName="test_candidate_analysis_test_candidate_analysis_id_seq", allocationSize=1)
    @Column(name="TEST_CANDIDATE_ANALYSIS_ID")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS", nullable=false, length=20)
    private AnalysisStatus status;
    @Column(name="NB_OF_PROCESSED_TC", nullable=false)
    private int nbOfProcessedTestCases = 0;
    @Column(name="NB_OF_TOTAL_TC", nullable=false)
    private int nbOfTotalTestCases;
    @Column(name="CREATED_BY", nullable=false, length=100)
    private String createdBy;
    @Column(name="CREATED_ON", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="TERMINATED_ON", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date terminatedOn;
    @ManyToMany
    @JoinTable(name="TEST_CANDIDATE_ANALYSIS_PROJECT", joinColumns={@JoinColumn(name="TEST_CANDIDATE_ANALYSIS_ID")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<Project> projects = new HashSet<Project>();

    public TestCandidateAnalysis() {
        this.status = AnalysisStatus.RUNNING;
        this.createdOn = new Date();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AnalysisStatus getStatus() {
        return this.status;
    }

    public void setStatus(AnalysisStatus status) {
        this.status = status;
    }

    public int getNbOfProcessedTestCases() {
        return this.nbOfProcessedTestCases;
    }

    public void setNbOfProcessedTestCases(int nbOfProcessedTestCases) {
        this.nbOfProcessedTestCases = nbOfProcessedTestCases;
    }

    public int getNbOfTotalTestCases() {
        return this.nbOfTotalTestCases;
    }

    public void setNbOfTotalTestCases(int nbOfTotalTestCases) {
        this.nbOfTotalTestCases = nbOfTotalTestCases;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getTerminatedOn() {
        return this.terminatedOn;
    }

    public void setTerminatedOn(Date terminatedOn) {
        this.terminatedOn = terminatedOn;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    public List<String> getProjectNames() {
        return this.getProjects().stream().map(GenericProject::getName).sorted().toList();
    }
}

