/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class FailureDetail
implements Identified,
IssueDetector {
    @Id
    @Column(name="FAILURE_DETAIL_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="failure_detail_failure_detail_id_seq")
    @SequenceGenerator(name="failure_detail_failure_detail_id_seq", sequenceName="failure_detail_failure_detail_id_seq", allocationSize=1)
    private Long id;
    @Column(name="MESSAGE")
    private String message;
    @JoinColumn(name="CREATED_BY")
    private String createdBy;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_PLAN_ITEM_ID", nullable=false)
    private TestPlanItem testPlanItem;
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="AUTOMATED_EXECUTION_FAILURE_DETAIL", inverseJoinColumns={@JoinColumn(name="EXECUTION_EXTENDER_ID", referencedColumnName="EXTENDER_ID")}, joinColumns={@JoinColumn(name="FAILURE_DETAIL_ID", referencedColumnName="FAILURE_DETAIL_ID")})
    private List<AutomatedExecutionExtender> automatedExecutions = new ArrayList<AutomatedExecutionExtender>();
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList = new IssueList();

    public FailureDetail() {
    }

    public FailureDetail(String message, String createdBy, Date createdOn, TestPlanItem testPlanItem) {
        this.message = message;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.testPlanItem = testPlanItem;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public TestPlanItem getTestPlanItem() {
        return this.testPlanItem;
    }

    public List<AutomatedExecutionExtender> getAutomatedExecutions() {
        return this.automatedExecutions;
    }

    public void addExecutionExtender(AutomatedExecutionExtender extender) {
        if (!this.automatedExecutions.contains(extender)) {
            this.automatedExecutions.add(extender);
        }
    }

    public List<Execution> getExecutions() {
        return this.getAutomatedExecutions().stream().map(AutomatedExecutionExtender::getExecution).toList();
    }

    @Override
    public IssueList getIssueList() {
        return this.issueList;
    }

    @Override
    public GenericProject getProject() {
        return this.testPlanItem.getProject();
    }

    @Override
    public BugTracker getBugTracker() {
        return this.testPlanItem.getProject().getBugTracker();
    }

    @Override
    public Long getIssueListId() {
        return this.issueList.getId();
    }

    @Override
    public List<Long> getAllIssueListId() {
        return Collections.singletonList(this.getIssueListId());
    }

    @Override
    public TestCase getReferencedTestCase() {
        return this.testPlanItem.getReferencedTestCase();
    }

    @Override
    public void detachIssue(Long id) {
        this.issueList.removeIssue(id);
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.testPlanItem.getCampaignLibrary();
    }
}

