/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.library.HasExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;

@NamedQueries(value={@NamedQuery(name="automatedSuite.findAll", query="from AutomatedSuite"), @NamedQuery(name="automatedSuite.findAllById", query="from AutomatedSuite where id in (:suiteIds)"), @NamedQuery(name="automatedSuite.findAllExtenders", query="select ext from AutomatedExecutionExtender ext join ext.automatedSuite s where s.id = :suiteId"), @NamedQuery(name="automatedSuite.findAllExtendersHavingStatus", query="select ext from AutomatedExecutionExtender ext join ext.execution exe join ext.automatedSuite s where s.id = :suiteId and exe.executionStatus in (:statusList)"), @NamedQuery(name="automatedSuite.fetchForAutomationExecution", query="select distinct ext from AutomatedExecutionExtender ext join fetch ext.execution exec join fetch exec.issueList join fetch exec.attachmentList join fetch exec.testPlanItem itpi  join fetch itpi.referencedTestCase tc join fetch tc.automatedTest autoTest join fetch tc.nature nat join fetch nat.infoList left join fetch tc.parameters left join fetch tc.automationRequest left join fetch itpi.referencedDataset dataset left join fetch dataset.parameterValues join fetch itpi.testPlan.parentIteration it join fetch it.campaign where ext.automatedSuite.id = :suiteId order by ext.id asc"), @NamedQuery(name="automatedSuite.countStatuses", query="select exec.executionStatus, count(exec) from AutomatedSuite asuite join asuite.executionExtenders ext join ext.execution exec where asuite.id = :id group by exec.executionStatus")})
@Entity
@Auditable
public class AutomatedSuite
extends BaseAuditableEntity
implements HasExecutionStatus,
AttachmentHolder {
    static final Set<ExecutionStatus> LEGAL_EXEC_STATUS;
    @Id
    @Column(name="SUITE_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="automated_suite_suite_id_seq")
    @SequenceGenerator(name="automated_suite_suite_id_seq", sequenceName="automated_suite_suite_id_seq", allocationSize=1)
    private Long id;
    @Column(name="UUID")
    private String uuid;
    @OneToMany(mappedBy="automatedSuite", cascade={CascadeType.ALL})
    @OrderBy
    private List<AutomatedExecutionExtender> executionExtenders = new ArrayList<AutomatedExecutionExtender>();
    @Enumerated(value=EnumType.STRING)
    private ExecutionStatus executionStatus = ExecutionStatus.READY;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ITERATION_ID")
    private Iteration iteration;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_SUITE_ID")
    private TestSuite testSuite;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @ElementCollection
    @CollectionTable(name="AUTOMATED_SUITE_WORKFLOWS", joinColumns={@JoinColumn(name="SUITE_ID")})
    @Column(name="WORKFLOW_ID")
    private List<AutomatedSuiteWorkflow> workflows;
    private transient Boolean manualSlaveSelection;

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.BLOCKED);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.UNTESTABLE);
        set.add(ExecutionStatus.SETTLED);
        set.add(ExecutionStatus.SKIPPED);
        set.add(ExecutionStatus.CANCELLED);
        LEGAL_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    public AutomatedSuite() {
        this.uuid = UUID.randomUUID().toString();
    }

    public AutomatedSuite(Iteration iteration) {
        this.iteration = iteration;
        this.uuid = UUID.randomUUID().toString();
    }

    public AutomatedSuite(TestSuite testSuite) {
        this.testSuite = testSuite;
        this.uuid = UUID.randomUUID().toString();
    }

    public Long getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<AutomatedExecutionExtender> getExecutionExtenders() {
        return this.executionExtenders;
    }

    public void setExecutionExtenders(List<AutomatedExecutionExtender> executionExtenders) {
        this.executionExtenders = executionExtenders;
    }

    public void addExtender(AutomatedExecutionExtender extender) {
        this.executionExtenders.add(extender);
        extender.setAutomatedSuite(this);
    }

    public void addExtenders(Collection<AutomatedExecutionExtender> extenders) {
        for (AutomatedExecutionExtender extender : extenders) {
            this.executionExtenders.add(extender);
        }
    }

    public boolean hasStarted() {
        for (AutomatedExecutionExtender extender : this.executionExtenders) {
            if (extender.getExecution().getExecutionStatus() == ExecutionStatus.READY) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnded() {
        for (AutomatedExecutionExtender extender : this.executionExtenders) {
            if (extender.getExecution().getExecutionStatus().isTerminatedStatus()) continue;
            return false;
        }
        return true;
    }

    public boolean isManualNodeSelection() {
        if (this.manualSlaveSelection == null) {
            boolean manual = false;
            for (AutomatedExecutionExtender autoExec : this.executionExtenders) {
                manual = autoExec.getAutomatedProject().getServer().isManualSlaveSelection();
                if (manual) break;
            }
            this.manualSlaveSelection = manual;
        }
        return this.manualSlaveSelection;
    }

    @Override
    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public Set<ExecutionStatus> getLegalStatusSet() {
        return null;
    }

    public Iteration getIteration() {
        if (this.iteration != null) {
            return this.iteration;
        }
        if (this.testSuite != null) {
            return this.testSuite.getIteration();
        }
        return null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        if (this.iteration != null) {
            return this.iteration.getProject().getId();
        }
        return this.testSuite.getProject().getId();
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.AUTOMATED_SUITE, this.id);
    }

    public List<AutomatedSuiteWorkflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(List<AutomatedSuiteWorkflow> workflows) {
        this.workflows = workflows;
    }
}

