/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.squashtest.tm.domain.search.AdvancedSearchModel;

public class AdvancedSearchQueryModel {
    private static final List<String> PARAMS_NOT_QUERYING = Arrays.asList("entity-index", "empty-openinterface2-holder", "empty-opentree-holder", "editable", "links");
    private Pageable pageable;
    private List<String> searchResultKeys = new ArrayList<String>();
    private AdvancedSearchModel searchFormModel;

    public AdvancedSearchQueryModel() {
    }

    public AdvancedSearchQueryModel(Pageable pageable, List<String> searchResultKeys, AdvancedSearchModel model) {
        this.pageable = pageable;
        this.searchResultKeys = searchResultKeys;
        this.searchFormModel = model;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public List<String> getSearchResultKeys() {
        ArrayList<String> columns = new ArrayList<String>(this.searchResultKeys);
        PARAMS_NOT_QUERYING.forEach(columns::remove);
        return columns;
    }

    public void setSearchResultKeys(List<String> searchResultKeys) {
        this.searchResultKeys = searchResultKeys;
    }

    public AdvancedSearchModel getSearchFormModel() {
        return this.searchFormModel;
    }

    public Set<String> getSearchFormKeys() {
        return new HashSet<String>(this.searchFormModel.getFieldKeys());
    }

    public void setModel(AdvancedSearchModel model) {
        this.searchFormModel = model;
    }
}

