/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.resource;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Auditable
public abstract class Resource
extends BaseAuditableEntity
implements AttachmentHolder,
Identified {
    @Id
    @Column(name="RES_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="resource_res_id_seq")
    @SequenceGenerator(name="resource_res_id_seq", sequenceName="resource_res_id_seq", allocationSize=30)
    private Long id;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @NotNull
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();

    @Override
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getDescription() {
        return HTMLSanitizeUtils.cleanHtml((String)this.description);
    }

    public void setDescription(String description) {
        this.description = HTMLSanitizeUtils.cleanHtml((String)description);
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    public int hashCode() {
        int result = 97;
        result = 61 * result + (this.getAttachmentList() == null ? 0 : this.getAttachmentList().hashCode());
        result = 61 * result + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        result = 61 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 61 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass()) && !obj.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.getAttachmentList() == null ? other.getAttachmentList() != null : !this.getAttachmentList().equals(other.getAttachmentList())) {
            return false;
        }
        if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }
}

