/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.squashtest.tm.domain.Level;

public enum RequirementCriticality implements Level,
Serializable
{
    MINOR(2),
    MAJOR(1),
    CRITICAL(0),
    UNDEFINED(3);

    private static final String I18N_KEY_ROOT = "requirement.criticality.";
    private final int level;

    private RequirementCriticality(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    public static StringComparator stringComparator() {
        return new StringComparator();
    }

    public String getCode() {
        return this.name();
    }

    public static RequirementCriticality findStrongestCriticality(List<RequirementCriticality> requirementCriticalities) {
        if (!requirementCriticalities.isEmpty()) {
            RequirementCriticality strongestRequirementCriticality = requirementCriticalities.get(0);
            for (RequirementCriticality requirementCriticality : requirementCriticalities) {
                if (strongestRequirementCriticality.getLevel() <= requirementCriticality.getLevel()) continue;
                strongestRequirementCriticality = requirementCriticality;
            }
            return strongestRequirementCriticality;
        }
        return null;
    }

    public static RequirementCriticality valueOf(String string) {
        return Enum.valueOf(RequirementCriticality.class, string);
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            RequirementCriticality s2;
            RequirementCriticality s1;
            try {
                s1 = RequirementCriticality.valueOf(o1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 1;
            }
            try {
                s2 = RequirementCriticality.valueOf(o2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }
}

