/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.query.NaturalJoinStyle;
import org.squashtest.tm.domain.query.QueryAggregationColumn;
import org.squashtest.tm.domain.query.QueryFilterColumn;
import org.squashtest.tm.domain.query.QueryOrderingColumn;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.query.QueryStrategy;

@Entity
@Table(name="QUERY_MODEL")
public class QueryModel {
    @Id
    @Column(name="QUERY_MODEL_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="query_model_query_model_id_seq")
    @SequenceGenerator(name="query_model_query_model_id_seq", sequenceName="query_model_query_model_id_seq", allocationSize=1)
    private Long id;
    private String name;
    @Enumerated(value=EnumType.STRING)
    private QueryStrategy strategy = QueryStrategy.MAIN;
    @Enumerated(value=EnumType.STRING)
    private NaturalJoinStyle joinStyle = NaturalJoinStyle.INNER_JOIN;
    @ElementCollection
    @CollectionTable(name="QUERY_AGGREGATION_COLUMN", joinColumns={@JoinColumn(name="QUERY_MODEL_ID")})
    @OrderColumn(name="AGGREGATION_RANK")
    private List<QueryAggregationColumn> aggregationColumns = new ArrayList<QueryAggregationColumn>();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="QUERY_MODEL_ID", nullable=false)
    private List<QueryFilterColumn> filterColumns = new ArrayList<QueryFilterColumn>();
    @ElementCollection
    @CollectionTable(name="QUERY_PROJECTION_COLUMN", joinColumns={@JoinColumn(name="QUERY_MODEL_ID")})
    @OrderColumn(name="PROJECTION_RANK")
    private List<QueryProjectionColumn> projectionColumns = new ArrayList<QueryProjectionColumn>();
    @ElementCollection
    @CollectionTable(name="QUERY_ORDERING_COLUMN", joinColumns={@JoinColumn(name="QUERY_MODEL_ID")})
    @OrderColumn(name="ORDER_RANK")
    private List<QueryOrderingColumn> orderingColumns = new ArrayList<QueryOrderingColumn>();

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public QueryStrategy getStrategy() {
        return this.strategy;
    }

    public NaturalJoinStyle getJoinStyle() {
        return this.joinStyle;
    }

    public List<QueryAggregationColumn> getAggregationColumns() {
        return this.aggregationColumns;
    }

    public List<QueryFilterColumn> getFilterColumns() {
        return this.filterColumns;
    }

    public List<QueryProjectionColumn> getProjectionColumns() {
        return this.projectionColumns;
    }

    public List<QueryOrderingColumn> getOrderingColumns() {
        return this.orderingColumns;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStrategy(QueryStrategy strategy) {
        this.strategy = strategy;
    }

    public void setJoinStyle(NaturalJoinStyle joinStyle) {
        this.joinStyle = joinStyle;
    }

    public void setAggregationColumns(List<QueryAggregationColumn> aggregationColumns) {
        this.aggregationColumns = aggregationColumns;
    }

    public void setFilterColumns(List<QueryFilterColumn> filterColumns) {
        this.filterColumns = filterColumns;
    }

    public void setProjectionColumns(List<QueryProjectionColumn> projectionColumns) {
        this.projectionColumns = projectionColumns;
    }

    public void setOrderingColumns(List<QueryOrderingColumn> orderingColumns) {
        this.orderingColumns = orderingColumns;
    }
}

