/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Entity
@Table(name="QUERY_FILTER_COLUMN")
public class QueryFilterColumn
implements QueryColumnPrototypeInstance {
    @Id
    @Column(name="QUERY_FILTER_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="query_filter_column_query_filter_id_seq")
    @SequenceGenerator(name="query_filter_column_query_filter_id_seq", sequenceName="query_filter_column_query_filter_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="QUERY_COLUMN_ID", nullable=false)
    private QueryColumnPrototype column;
    @Enumerated(value=EnumType.STRING)
    @Column(name="FILTER_OPERATION")
    private Operation operation;
    private Long cufId;
    @ElementCollection
    @CollectionTable(name="QUERY_FILTER_VALUES", joinColumns={@JoinColumn(name="QUERY_FILTER_ID")})
    @Column(name="FILTER_VALUE")
    private List<String> values = new ArrayList<String>();

    @Override
    public QueryColumnPrototype getColumn() {
        return this.column;
    }

    @Override
    public EntityType getEntityType() {
        return this.column.getEntityType();
    }

    @Override
    public SpecializedEntityType getSpecializedType() {
        return this.column.getSpecializedType();
    }

    @Override
    public DataType getDataType() {
        return this.column.getDataType();
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Long getCufId() {
        return this.cufId;
    }

    public void setColumn(QueryColumnPrototype column) {
        this.column = column;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValues(List<String> values) {
        this.values.addAll(values);
    }

    public void removeValues(List<String> values) {
        this.values.removeAll(values);
    }
}

