/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.projectfilter;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.SequenceGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;

@Entity
public class ProjectFilter {
    @Id
    @Column(name="PROJECT_FILTER_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="project_filter_project_filter_id_seq")
    @SequenceGenerator(name="project_filter_project_filter_id_seq", sequenceName="project_filter_project_filter_id_seq", allocationSize=1)
    private Long id;
    private String userLogin;
    private boolean activated;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="PROJECT_FILTER_ENTRY", joinColumns={@JoinColumn(name="FILTER_ID")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID")})
    private final List<Project> projects = new ArrayList<Project>();

    public void setProjects(List<Project> newProjectList) {
        this.projects.clear();
        this.projects.addAll(newProjectList);
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Long getId() {
        return this.id;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public boolean getActivated() {
        return this.activated;
    }

    public boolean isEnabled() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean isProjectSelected(GenericProject project) {
        boolean result = false;
        for (Project localProject : this.projects) {
            if (!project.getId().equals(localProject.getId())) continue;
            result = true;
        }
        return result;
    }

    public void removeProject(Project project) {
        Iterator<Project> projectIterator = this.projects.iterator();
        while (projectIterator.hasNext()) {
            Project projectItem = projectIterator.next();
            if (!projectItem.getId().equals(project.getId())) continue;
            projectIterator.remove();
        }
    }
}

