/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library.structures;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StringPathMap<T> {
    private Map<String, T> map = new HashMap<String, T>();

    public void put(String path, T ref) {
        this.map.put(path, ref);
    }

    public T getMappedElement(String path) {
        return this.map.get(path);
    }

    public String getPath(T needle) {
        for (Map.Entry<String, T> entry : this.map.entrySet()) {
            T ref = entry.getValue();
            if (!ref.equals(needle)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<String> getKnownChildrenPath(String path) {
        if (!this.map.containsKey(path)) {
            return Collections.emptyList();
        }
        LinkedList<String> children = new LinkedList<String>();
        for (String p : this.map.keySet()) {
            if (!p.matches("^" + path + "/?[^/]+$")) continue;
            children.add(p);
        }
        return children;
    }

    public static List<String> tokenizePath(String path) {
        LinkedList<String> tokens = new LinkedList<String>();
        String[] toks = path.split("/");
        tokens.add("/");
        tokens.addAll(Arrays.asList(toks));
        tokens.remove("");
        return tokens;
    }
}

