/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library.structures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.squashtest.tm.domain.library.structures.GraphNode;

public class LibraryGraph<IDENT, T extends GraphNode<IDENT, T>> {
    private Set<T> nodes = new HashSet<T>();

    public Collection<T> getNodes() {
        return this.nodes;
    }

    public void addNode(T node) {
        if (node != null && ((GraphNode)node).getKey() != null) {
            this.createIfNotExists(node);
        }
    }

    public void addEdge(T parentNode, T childNode) {
        GraphNode parent = null;
        GraphNode child = null;
        if (parentNode != null && ((GraphNode)parentNode).getKey() != null) {
            parent = (GraphNode)this.createIfNotExists(parentNode);
        }
        if (childNode != null && ((GraphNode)childNode).getKey() != null) {
            child = (GraphNode)this.createIfNotExists(childNode);
        }
        if (parent != null) {
            parent.addOutbound(child);
        }
        if (child != null) {
            child.addInbound(parent);
        }
    }

    public T getNode(IDENT key) {
        GraphNode toReturn = null;
        if (key != null) {
            for (GraphNode node : this.nodes) {
                if (!node.getKey().equals(key)) continue;
                toReturn = node;
            }
        }
        return (T)toReturn;
    }

    protected T createIfNotExists(T node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
        return this.getNode(((GraphNode)node).getKey());
    }

    public boolean hasEdge(IDENT src, IDENT dest) {
        T srcNode = this.getNode(src);
        T destNode = this.getNode(dest);
        return srcNode != null && destNode != null && ((GraphNode)srcNode).getOutbounds().contains(destNode);
    }

    public int cardEdge(IDENT src, IDENT dest) {
        int cardinality = 0;
        T srcNode = this.getNode(src);
        T destNode = this.getNode(dest);
        if (srcNode != null && destNode != null) {
            for (GraphNode node : ((GraphNode)srcNode).getOutbounds()) {
                if (!node.equals(destNode)) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public void removeNode(IDENT target) {
        GraphNode n = this.getNode(target);
        if (n != null) {
            for (GraphNode othernode : this.getNodes()) {
                if (othernode.equals(n)) continue;
                othernode.disconnect(n);
                n.disconnect((GraphNode)othernode);
            }
            this.getNodes().remove(n);
        }
    }

    public void removeEdge(IDENT src, IDENT dest) {
        T srcNode = this.getNode(src);
        T destNode = this.getNode(dest);
        if (srcNode != null) {
            ((GraphNode)srcNode).getOutbounds().remove(destNode);
        }
        if (destNode != null) {
            ((GraphNode)destNode).getInbounds().remove(srcNode);
        }
    }

    public void removeAllEdges(IDENT src, IDENT dest) {
        T srcNode = this.getNode(src);
        T destNode = this.getNode(dest);
        if (srcNode != null && destNode != null) {
            ((GraphNode)srcNode).disconnect(destNode);
        }
    }

    public void disconnect(IDENT src, IDENT dest) {
        T srcNode = this.getNode(src);
        T destNode = this.getNode(dest);
        if (srcNode != null && destNode != null) {
            ((GraphNode)srcNode).disconnect(destNode);
            ((GraphNode)destNode).disconnect(srcNode);
        }
    }

    public List<T> getOrphans() {
        return this.getNodes().stream().filter((? super T node) -> node.getInbounds().isEmpty()).toList();
    }

    public List<T> getChildless() {
        return this.getNodes().stream().filter((? super T node) -> node.getOutbounds().isEmpty()).toList();
    }

    public <X> List<X> collect(Function<T, X> transformer) {
        return this.getNodes().stream().map(transformer).toList();
    }

    public List<T> filter(Predicate predicate) {
        ArrayList<T> result = new ArrayList<T>(this.getNodes());
        CollectionUtils.filter(result, (Predicate)predicate);
        return result;
    }

    public <OIDENT, ON extends GraphNode<OIDENT, ON>, OG extends LibraryGraph<OIDENT, ON>> void mergeGraph(OG othergraph, NodeTransformer<ON, T> transformer) {
        LinkedList<ON> processing = new LinkedList<ON>(othergraph.getOrphans());
        HashSet<GraphNode> processed = new HashSet<GraphNode>();
        while (!processing.isEmpty()) {
            GraphNode current = (GraphNode)processing.pop();
            GraphNode newParent = (GraphNode)transformer.createFrom(current);
            for (GraphNode child : current.getOutbounds()) {
                this.addEdge(newParent, (GraphNode)transformer.createFrom(child));
                if (processed.contains(child)) continue;
                processing.add(child);
                processed.add(child);
            }
            this.addNode(newParent);
        }
    }

    public <OIDENT, ON extends GraphNode<OIDENT, ON>, OG extends LibraryGraph<OIDENT, ON>> void substractGraph(OG othergraph, NodeTransformer<ON, T> transformer, boolean removeAll) {
        LinkedList<ON> processing = new LinkedList<ON>(othergraph.getOrphans());
        HashSet<GraphNode> processed = new HashSet<GraphNode>();
        while (!processing.isEmpty()) {
            GraphNode otherCurrent = (GraphNode)processing.pop();
            Object thisCurrent = transformer.createKey(otherCurrent);
            for (GraphNode otherChild : otherCurrent.getOutbounds()) {
                Object thisChild = transformer.createKey(otherChild);
                this.removeEdges(removeAll, thisCurrent, thisChild);
                if (processed.contains(otherChild)) continue;
                processing.add(otherChild);
                processed.add(otherChild);
            }
        }
    }

    private void removeEdges(boolean removeAll, IDENT thisCurrent, IDENT thisChild) {
        if (this.hasEdge(thisCurrent, thisChild)) {
            if (removeAll) {
                this.removeAllEdges(thisCurrent, thisChild);
            } else {
                this.removeEdge(thisCurrent, thisChild);
            }
        }
    }

    public static interface NodeTransformer<FORMER, NEW> {
        public NEW createFrom(FORMER var1);

        public Object createKey(FORMER var1);
    }

    public static final class SimpleNode<T>
    extends GraphNode<T, SimpleNode<T>> {
        public SimpleNode() {
        }

        public SimpleNode(T key) {
            super(key);
        }
    }
}

