/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCaseFolder;

public class NewFolderDto {
    private String name;
    private String description;
    private Map<Long, RawValue> customFields = new HashMap<Long, RawValue>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<Long, RawValue> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<Long, RawValue> customFields) {
        this.customFields = customFields;
    }

    public Folder<?> toFolder(EntityType type) {
        BaseAuditableEntity folder = switch (type) {
            case EntityType.CAMPAIGN_FOLDER -> new CampaignFolder();
            case EntityType.REQUIREMENT_FOLDER -> new RequirementFolder();
            case EntityType.TEST_CASE_FOLDER -> new TestCaseFolder();
            default -> throw new IllegalArgumentException("Entity of type " + type.name() + " is not supported");
        };
        folder.setName(this.name);
        folder.setDescription(this.description);
        return folder;
    }
}

