/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.squashtest.tm.domain.jpql.HibernateDialectExtensions;

public class H2EnhancedDialect
extends H2Dialect {
    private static final String STRAIGHT_JOIN = "STRAIGHT_JOIN";

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        Map<String, StandardSQLFunction> extensions = HibernateDialectExtensions.getH2DialectExtensions();
        for (Map.Entry<String, StandardSQLFunction> extension : extensions.entrySet()) {
            functionContributions.getFunctionRegistry().register(extension.getKey(), (SqmFunctionDescriptor)extension.getValue());
        }
    }

    public String getQueryHintString(String sql, List<String> hints) {
        hints.remove(STRAIGHT_JOIN);
        return super.getQueryHintString(sql, hints);
    }
}

