/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.jpql;

import com.querydsl.core.Tuple;
import com.querydsl.core.dml.InsertClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPQLQueryFactory;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.hibernate.HibernateDeleteClause;
import com.querydsl.jpa.hibernate.HibernateInsertClause;
import com.querydsl.jpa.hibernate.HibernateQuery;
import com.querydsl.jpa.hibernate.HibernateUpdateClause;
import jakarta.inject.Provider;
import org.hibernate.Session;
import org.squashtest.tm.domain.jpql.ExtHQLTemplates;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.jpql.FixedSessionHolders;

public class ExtendedHibernateQueryFactory
implements JPQLQueryFactory {
    private final JPQLTemplates templates;
    private final Provider<Session> session;

    public ExtendedHibernateQueryFactory(Session session) {
        this((JPQLTemplates)ExtHQLTemplates.INSTANCE, session);
    }

    public ExtendedHibernateQueryFactory(JPQLTemplates templates, final Session session) {
        this.session = new Provider<Session>(){

            public Session get() {
                return session;
            }
        };
        this.templates = templates;
    }

    public ExtendedHibernateQueryFactory(Provider<Session> session) {
        this((JPQLTemplates)ExtHQLTemplates.INSTANCE, session);
    }

    public ExtendedHibernateQueryFactory(JPQLTemplates templates, Provider<Session> session) {
        this.session = session;
        this.templates = templates;
    }

    public HibernateDeleteClause delete(EntityPath<?> path) {
        return new HibernateDeleteClause(FixedSessionHolders.defaultSessionHolder((Session)this.session.get()), path, this.templates);
    }

    public <T> HibernateQuery<T> select(Expression<T> expr) {
        return this.query().select(expr);
    }

    public HibernateQuery<Tuple> select(Expression<?> ... exprs) {
        return this.query().select(exprs);
    }

    public <T> HibernateQuery<T> selectDistinct(Expression<T> expr) {
        return (HibernateQuery)this.select(expr).distinct();
    }

    public HibernateQuery<Tuple> selectDistinct(Expression<?> ... exprs) {
        return (HibernateQuery)this.select(exprs).distinct();
    }

    public HibernateQuery<Integer> selectOne() {
        return this.select((Expression<T>)((Expression)Expressions.ONE));
    }

    public HibernateQuery<Integer> selectZero() {
        return this.select((Expression<T>)((Expression)Expressions.ZERO));
    }

    public <T> HibernateQuery<T> selectFrom(EntityPath<T> from) {
        return (HibernateQuery)this.select((Expression<T>)from).from(from);
    }

    public HibernateQuery<?> from(EntityPath<?> from) {
        return (HibernateQuery)this.query().from(from);
    }

    public HibernateQuery<?> from(EntityPath<?> ... from) {
        return (HibernateQuery)this.query().from(from);
    }

    public HibernateUpdateClause update(EntityPath<?> path) {
        return new HibernateUpdateClause(FixedSessionHolders.defaultSessionHolder((Session)this.session.get()), path, this.templates);
    }

    public InsertClause<?> insert(EntityPath<?> path) {
        return new HibernateInsertClause(FixedSessionHolders.defaultSessionHolder((Session)this.session.get()), path, this.templates);
    }

    public HibernateQuery<?> query() {
        return new ExtendedHibernateQuery((Session)this.session.get(), this.templates);
    }
}

