/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.infolist;

import org.squashtest.tm.domain.infolist.InfoList;

public enum SystemInfoListCode {
    TEST_CASE_NATURE("DEF_TC_NAT"),
    TEST_CASE_TYPE("DEF_TC_TYP"),
    REQUIREMENT_CATEGORY("DEF_REQ_CAT");

    private final String code;

    private SystemInfoListCode(String code) {
        this.code = code;
    }

    public static void verifyModificationPermission(InfoList infoList) {
        SystemInfoListCode[] systemInfoListCodeArray = SystemInfoListCode.values();
        int n = systemInfoListCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemInfoListCode id = systemInfoListCodeArray[n2];
            if (id.getCode().equals(infoList.getCode())) {
                throw new IllegalAccessError("You shall not pass ! This is a system info list, go away ! Play with your own info lists");
            }
            ++n2;
        }
    }

    public static boolean isSystem(String code) {
        SystemInfoListCode[] systemInfoListCodeArray = SystemInfoListCode.values();
        int n = systemInfoListCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemInfoListCode sys = systemInfoListCodeArray[n2];
            if (sys.getCode().equals(code)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSystem(InfoList list) {
        return SystemInfoListCode.isSystem(list.getCode());
    }

    public static boolean isNotSystem(String code) {
        return !SystemInfoListCode.isSystem(code);
    }

    public static boolean isNotSystem(InfoList list) {
        return !SystemInfoListCode.isSystem(list);
    }

    public String getCode() {
        return this.code;
    }
}

