/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.infolist;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.infolist.InfoList;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="ITEM_TYPE", discriminatorType=DiscriminatorType.STRING)
public abstract class InfoListItem
implements Identified {
    public static final String NO_ICON = "noicon";
    @Id
    @Column(name="ITEM_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="info_list_item_item_id_seq")
    @SequenceGenerator(name="info_list_item_item_id_seq", sequenceName="info_list_item_item_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LIST_ID", insertable=false, updatable=false)
    private InfoList infoList;
    @Size(max=100)
    @NotBlank
    private @Size(max=100) @NotBlank String label = "";
    @Size(max=30)
    @NotBlank
    private @Size(max=30) @NotBlank String code = "";
    private boolean isDefault = false;
    @Size(max=100)
    private @Size(max=100) String iconName = "";
    @Size(max=7)
    private @Size(max=7) String colour;

    public InfoList getInfoList() {
        return this.infoList;
    }

    public void setInfoList(InfoList infoList) {
        this.infoList = infoList;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getIconName() {
        if (!StringUtils.isBlank((CharSequence)this.iconName)) {
            return this.iconName;
        }
        return NO_ICON;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public boolean references(Object other) {
        if (other == null) {
            return false;
        }
        if (InfoListItem.class.isAssignableFrom(other.getClass())) {
            return ((InfoListItem)other).getCode().equals(this.getCode());
        }
        return false;
    }
}

