/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.infolist;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.validation.constraint.HasDefaultItem;
import org.squashtest.tm.validation.constraint.UniqueItems;

@Entity
@Auditable
public class InfoList
extends BaseAuditableEntity
implements Identified {
    @Id
    @Column(name="INFO_LIST_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="info_list_info_list_id_seq")
    @SequenceGenerator(name="info_list_info_list_id_seq", sequenceName="info_list_info_list_id_seq", allocationSize=1)
    private Long id;
    @Size(max=100)
    @NotBlank
    private @Size(max=100) @NotBlank String label = "";
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @Size(max=30)
    @NotBlank
    private @Size(max=30) @NotBlank String code;
    @Valid
    @UniqueItems
    @HasDefaultItem(value="isDefault")
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="ITEM_INDEX")
    @JoinColumn(name="LIST_ID")
    private List<InfoListItem> items = new ArrayList<InfoListItem>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public List<InfoListItem> getItems() {
        return this.items;
    }

    public InfoListItem getItem(InfoListItem item) {
        for (InfoListItem thisitem : this.items) {
            if (!item.references(thisitem)) continue;
            return thisitem;
        }
        return null;
    }

    public InfoListItem getItem(String code) {
        for (InfoListItem thisitem : this.items) {
            if (!thisitem.getCode().equals(code)) continue;
            return thisitem;
        }
        return null;
    }

    public void addItem(InfoListItem item) {
        this.items.add(item);
    }

    public void removeItem(InfoListItem item) {
        this.removeItem(item.getCode());
    }

    public void removeItem(Long itemId) {
        Iterator<InfoListItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            if (!itemId.equals(iter.next().getId())) continue;
            iter.remove();
            return;
        }
    }

    public void removeItem(String code) {
        Iterator<InfoListItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            if (!code.equals(iter.next().getCode())) continue;
            iter.remove();
            return;
        }
    }

    public InfoListItem getDefaultItem() {
        for (InfoListItem it : this.items) {
            if (!it.isDefault()) continue;
            return it;
        }
        throw new IllegalStateException("No default item was defined for this list");
    }

    public boolean contains(InfoListItem item) {
        for (InfoListItem it : this.items) {
            if (!it.references(item)) continue;
            return true;
        }
        return false;
    }

    public void addItems(int newIndex, List<InfoListItem> addedItems) {
        this.items.addAll(newIndex, addedItems);
    }
}

