/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import java.util.Collections;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.common.ordered.Ordered;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNoteKind;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Auditable
public class SessionNote
extends BaseAuditableEntity
implements Identified,
AttachmentHolder,
IssueDetector,
Ordered {
    @Id
    @Column(name="NOTE_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="session_note_note_id_seq")
    @SequenceGenerator(name="session_note_note_id_seq", sequenceName="session_note_note_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="EXECUTION_ID", nullable=false)
    private ExploratoryExecution execution;
    @Enumerated(value=EnumType.STRING)
    private SessionNoteKind kind;
    @Lob
    @JdbcTypeCode(value=-1)
    private String content;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID", updatable=false)
    private final AttachmentList attachmentList = new AttachmentList();
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList = new IssueList();
    @Column(name="NOTE_ORDER")
    private int noteOrder;

    @Override
    public Long getId() {
        return this.id;
    }

    public ExploratoryExecution getExecution() {
        return this.execution;
    }

    public void setExecution(ExploratoryExecution execution) {
        this.execution = execution;
    }

    public SessionNoteKind getKind() {
        return this.kind;
    }

    public void setKind(SessionNoteKind kind) {
        this.kind = kind;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setIssueList(IssueList issueList) {
        this.issueList = issueList;
    }

    public int getNoteOrder() {
        return this.noteOrder;
    }

    public void setNoteOrder(int noteOrder) {
        this.noteOrder = noteOrder;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.execution.getCampaignLibrary();
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.SESSION_NOTE, this.getId());
    }

    @Override
    public IssueList getIssueList() {
        return this.issueList;
    }

    @Override
    public GenericProject getProject() {
        return this.execution.getProject();
    }

    @Override
    public BugTracker getBugTracker() {
        return this.getProject().findBugTracker();
    }

    @Override
    public Long getIssueListId() {
        return this.issueList.getId();
    }

    @Override
    public List<Long> getAllIssueListId() {
        return Collections.singletonList(this.getIssueListId());
    }

    @Override
    public TestCase getReferencedTestCase() {
        return this.execution.getReferencedTestCase();
    }

    @Override
    public void detachIssue(Long id) {
        this.issueList.removeIssue(id);
    }

    @Override
    public void setOrder(Integer newOrder) {
        this.noteOrder = newOrder;
    }
}

