/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEventType;

@Entity
public class ExploratoryExecutionEvent {
    @Id
    @Column(name="EVENT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="exploratory_execution_event_event_id_seq")
    @SequenceGenerator(name="exploratory_execution_event_event_id_seq", sequenceName="exploratory_execution_event_event_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="EXECUTION_ID")
    @NotNull
    private ExploratoryExecution exploratoryExecution;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column(name="EVENT_DATE")
    private Date date;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String author;
    @Enumerated(value=EnumType.STRING)
    @Column(name="EVENT_TYPE")
    private ExploratoryExecutionEventType eventType;

    public ExploratoryExecutionEvent() {
    }

    public ExploratoryExecutionEvent(ExploratoryExecution exploratoryExecution, Date date, String author, ExploratoryExecutionEventType eventType) {
        this.exploratoryExecution = exploratoryExecution;
        this.date = date;
        this.author = author;
        this.eventType = eventType;
    }

    public Long getId() {
        return this.id;
    }

    public ExploratoryExecution getExploratoryExecution() {
        return this.exploratoryExecution;
    }

    public void setExploratoryExecution(ExploratoryExecution exploratoryExecution) {
        this.exploratoryExecution = exploratoryExecution;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public ExploratoryExecutionEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(ExploratoryExecutionEventType eventType) {
        this.eventType = eventType;
    }
}

