/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.common.ordered.OrderedListHelper;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionVisitor;
import org.squashtest.tm.domain.execution.ExploratoryExecutionEvent;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.users.User;

@Entity
@PrimaryKeyJoinColumn(name="EXECUTION_ID")
public class ExploratoryExecution
extends Execution {
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ASSIGNEE_ID")
    private User assigneeUser;
    @NotNull
    @Column
    private boolean reviewed = false;
    @Column
    @Size(max=255)
    private @Size(max=255) String taskDivision;
    @NotNull
    @OneToMany(mappedBy="execution", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @OrderBy(value="noteOrder")
    private List<SessionNote> sessionNotes = new ArrayList<SessionNote>();
    @NotNull
    @OneToMany(mappedBy="exploratoryExecution", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ExploratoryExecutionEvent> events = new ArrayList<ExploratoryExecutionEvent>();

    public ExploratoryExecution() {
        this.executionMode = TestCaseExecutionMode.EXPLORATORY;
    }

    public ExploratoryExecution(ExploratoryTestCase exploratoryTestCase) {
        super(exploratoryTestCase);
        this.executionMode = TestCaseExecutionMode.EXPLORATORY;
    }

    @Override
    public void accept(ExecutionVisitor executionVisitor) {
        executionVisitor.visit(this);
    }

    public User getAssigneeUser() {
        return this.assigneeUser;
    }

    public void setAssigneeUser(User assigneeUser) {
        this.assigneeUser = assigneeUser;
    }

    public boolean isReviewed() {
        return this.reviewed;
    }

    public void setReviewed(boolean reviewed) {
        this.reviewed = reviewed;
    }

    public String getTaskDivision() {
        return this.taskDivision;
    }

    public void setTaskDivision(String taskDivision) {
        this.taskDivision = taskDivision;
    }

    public List<SessionNote> getSessionNotes() {
        return this.sessionNotes;
    }

    public void setSessionNotes(List<SessionNote> sessionNotes) {
        this.sessionNotes = sessionNotes;
    }

    public List<ExploratoryExecutionEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ExploratoryExecutionEvent> sessionEvents) {
        this.events = sessionEvents;
    }

    public void addSessionNote(SessionNote noteToAdd, Integer position) {
        new OrderedListHelper<SessionNote>(this.sessionNotes).addContent(noteToAdd, position);
    }

    public void removeSessionNote(SessionNote noteToRemove) {
        this.sessionNotes.remove(noteToRemove);
        new OrderedListHelper<SessionNote>(this.sessionNotes).reorder();
    }

    public void moveSessionNotes(Integer newIndex, List<SessionNote> movedNotes) {
        if (!this.sessionNotes.isEmpty() && !movedNotes.isEmpty()) {
            new OrderedListHelper<SessionNote>(this.sessionNotes).moveContent(movedNotes, newIndex);
        }
    }
}

