/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.LevelUtils;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;

public enum ExecutionStatus implements Internationalizable,
Level
{
    READY(1){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : this.needsComputation();
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return READY;
        }

        @Override
        public boolean isTerminatedStatus() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    RUNNING(2){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : (formerExecutionStatus == READY ? READY : (formerExecutionStatus == RUNNING ? this.needsComputation() : RUNNING));
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return RUNNING;
        }

        @Override
        public boolean isTerminatedStatus() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    SUCCESS(3){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            ExecutionStatus newStatus = formerExecutionStatus == FAILURE ? FAILURE : (formerStepStatus == RUNNING && formerExecutionStatus == READY ? RUNNING : this.needsComputation());
            return newStatus;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SUCCESS;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    WARNING(4){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_WARNING#resolveStatus(...) should never have been invoked. If you read this message please report the issue at https://gitlab.com/henixdevelopment/open-source/squash/squashtest-tm-staging/-/issues.Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help!");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SUCCESS;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    SETTLED(5){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return this.needsComputation();
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SETTLED;
        }

        @Override
        public boolean canBeDisabled() {
            return true;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.SUCCESS;
        }
    }
    ,
    SKIPPED(6){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return SKIPPED;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return SKIPPED;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    CANCELLED(7){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return CANCELLED;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return CANCELLED;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    FAILURE(8){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return FAILURE;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return FAILURE;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.FAILURE;
        }
    }
    ,
    BLOCKED(9){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return BLOCKED;
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    NOT_RUN(10){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_NOT_RUN#resolveStatus(...) should never have been invoked. If you read this message please report the issue at https://gitlab.com/henixdevelopment/open-source/squash/squashtest-tm-staging/-/issues. Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help!");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    ERROR(11){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_ERROR#resolveStatus(...) should never have been invoked. If you read this message please report the issue at https://gitlab.com/henixdevelopment/open-source/squash/squashtest-tm-staging/-/issues. Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help!");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return BLOCKED;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    UNTESTABLE(12){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            return this.needsComputation();
        }

        @Override
        public boolean isCanonical() {
            return true;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return UNTESTABLE;
        }

        @Override
        public boolean canBeDisabled() {
            return true;
        }

        @Override
        public boolean defaultEnabled() {
            return true;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    }
    ,
    NOT_FOUND(13){

        @Override
        protected ExecutionStatus resolveStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
            throw new UnsupportedOperationException("ExecutionStatus.TA_NOT_FOUND#resolveStatus(...) should never have been invoked. If you read this message please report the issue at https://gitlab.com/henixdevelopment/open-source/squash/squashtest-tm-staging/-/issues. Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help!");
        }

        @Override
        public boolean isCanonical() {
            return false;
        }

        @Override
        public ExecutionStatus getCanonicalStatus() {
            return UNTESTABLE;
        }

        @Override
        public boolean defaultEnabled() {
            return false;
        }

        @Override
        public Conclusiveness getConclusiveness() {
            return Conclusiveness.NON_CONCLUSIVE;
        }
    };

    private static final String LOG_MSG_RESOLVESTATUS_ERROR = "should never have been invoked. If you read this message please report the issue at https://gitlab.com/henixdevelopment/open-source/squash/squashtest-tm-staging/-/issues. Please put [ExecutionStatus - unsupported operation] as title for your report and explain what you did. Also please check that it hadn't been reported already. Thanks for your help!";
    private static final String I18N_KEY_ROOT = "execution.execution-status.";
    private static final Set<ExecutionStatus> CANONICAL_STATUSES;
    public static final Set<ExecutionStatus> TERMINAL_STATUSES;
    private static final Set<ExecutionStatus> NON_TERMINAL_STATUSES;
    public static final Set<ExecutionStatus> TA_STATUSES_ONLY;
    public static final Set<ExecutionStatus> DEFAULT_DISABLED_STATUSES;
    public static final Set<ExecutionStatus> SUCCESS_STATUSES;
    private final int level;

    static {
        CANONICAL_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, ExecutionStatus::isCanonical);
        TERMINAL_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, ExecutionStatus::isTerminatedStatus);
        NON_TERMINAL_STATUSES = LevelUtils.excludeFromLevelEnum(ExecutionStatus.class, ExecutionStatus::isTerminatedStatus);
        DEFAULT_DISABLED_STATUSES = Set.of(SETTLED);
        TA_STATUSES_ONLY = Set.of(ERROR, WARNING, NOT_FOUND, NOT_RUN, SKIPPED, CANCELLED);
        SUCCESS_STATUSES = LevelUtils.filterLevelEnum(ExecutionStatus.class, Conclusiveness::concludeToSuccess);
    }

    private ExecutionStatus(int level) {
        this.level = level;
    }

    public static Set<ExecutionStatus> getSuccessStatusSet() {
        return SUCCESS_STATUSES;
    }

    @Deprecated
    public boolean defaultEnabled() {
        return true;
    }

    public boolean canBeDisabled() {
        return false;
    }

    public boolean isTerminatedStatus() {
        return true;
    }

    protected ExecutionStatus isAmbiguous() {
        return null;
    }

    protected boolean isAmbiguous(ExecutionStatus status) {
        return status == null;
    }

    protected ExecutionStatus needsComputation() {
        return null;
    }

    protected abstract ExecutionStatus resolveStatus(ExecutionStatus var1, ExecutionStatus var2);

    public abstract boolean isCanonical();

    public abstract ExecutionStatus getCanonicalStatus();

    public abstract Conclusiveness getConclusiveness();

    public static List<ExecutionStatus> toCanonicalStatusList(List<ExecutionStatus> nonCanonical) {
        ArrayList<ExecutionStatus> canonical = new ArrayList<ExecutionStatus>();
        for (ExecutionStatus nStatus : nonCanonical) {
            canonical.add(nStatus.getCanonicalStatus());
        }
        return canonical;
    }

    public static Set<ExecutionStatus> getCanonicalStatusSet() {
        return CANONICAL_STATUSES;
    }

    public static Set<ExecutionStatus> getTerminatedStatusSet() {
        return TERMINAL_STATUSES;
    }

    public static Set<ExecutionStatus> getNonTerminatedStatusSet() {
        return NON_TERMINAL_STATUSES;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String getI18nKey() {
        return I18N_KEY_ROOT + this.name();
    }

    public ExecutionStatus deduceNewStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return this.getCanonicalStatus().doDeduceNewStatus(formerExecutionStatus.getCanonicalStatus(), formerStepStatus.getCanonicalStatus());
    }

    protected boolean isNoneOf(ExecutionStatus ... status) {
        ExecutionStatus[] executionStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus state = executionStatusArray[n2];
            if (this == state) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected ExecutionStatus doDeduceNewStatus(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        ExecutionStatus deductedStatus = this.trivialDeductions(formerExecutionStatus, formerStepStatus);
        if (!this.isAmbiguous(deductedStatus)) {
            return deductedStatus;
        }
        boolean needComputation = this.trivialNeedComputation(formerExecutionStatus, formerStepStatus);
        return needComputation ? null : this.resolveStatus(formerExecutionStatus, formerStepStatus);
    }

    public static ExecutionStatus computeNewStatus(ExecutionStatusReport report) {
        if (report.getTotal() == 0) {
            return READY;
        }
        if (report.has(CANCELLED)) {
            return CANCELLED;
        }
        if (report.has(BLOCKED)) {
            return BLOCKED;
        }
        if (report.allOf(SKIPPED)) {
            return SKIPPED;
        }
        if (report.allOf(UNTESTABLE, SKIPPED)) {
            return UNTESTABLE;
        }
        if (report.allOf(SETTLED, UNTESTABLE, SKIPPED)) {
            return SETTLED;
        }
        if (report.has(FAILURE)) {
            return FAILURE;
        }
        if (report.allOf(SUCCESS, UNTESTABLE, SETTLED, SKIPPED)) {
            return SUCCESS;
        }
        if (report.anyOf(SUCCESS, SETTLED, RUNNING, SKIPPED)) {
            return RUNNING;
        }
        return READY;
    }

    public static ExecutionStatus computeNewStatusForAutomatedSuite(ExecutionStatusReport report) {
        if (ExecutionStatus.isReady(report)) {
            return READY;
        }
        if (report.anyOf(READY, RUNNING)) {
            return RUNNING;
        }
        if (report.has(CANCELLED)) {
            return CANCELLED;
        }
        if (report.has(BLOCKED)) {
            return BLOCKED;
        }
        if (report.allOf(SKIPPED)) {
            return SKIPPED;
        }
        if (report.allOf(UNTESTABLE, SKIPPED)) {
            return UNTESTABLE;
        }
        if (report.allOf(SETTLED, UNTESTABLE, SKIPPED)) {
            return SETTLED;
        }
        if (report.has(FAILURE)) {
            return FAILURE;
        }
        if (report.allOf(SUCCESS, UNTESTABLE, SETTLED, SKIPPED)) {
            return SUCCESS;
        }
        return READY;
    }

    private static boolean isReady(ExecutionStatusReport report) {
        return report.getTotal() == 0 || report.allOf(READY);
    }

    protected ExecutionStatus trivialDeductions(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        ExecutionStatus newStatus = !this.hasChanged(formerStepStatus) ? formerExecutionStatus : (this.isSetToExecutionStatus(formerExecutionStatus) ? formerExecutionStatus : (this.wontUnlockBloquedExecution(formerExecutionStatus, formerStepStatus) ? BLOCKED : this.isAmbiguous()));
        return newStatus;
    }

    protected boolean trivialNeedComputation(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        boolean isMandatory = false;
        if (this.mayUnlockBloquedExecution(formerStepStatus)) {
            isMandatory = true;
        } else if (this.couldHaveSetExecStatusAlone(formerExecutionStatus, formerStepStatus)) {
            isMandatory = true;
        } else if (this == UNTESTABLE) {
            isMandatory = true;
        }
        return isMandatory;
    }

    protected boolean hasChanged(ExecutionStatus formerStepStatus) {
        return this != formerStepStatus;
    }

    protected boolean isSetToExecutionStatus(ExecutionStatus formerExecutionStatus) {
        if (this == RUNNING) {
            return false;
        }
        return this == formerExecutionStatus;
    }

    protected boolean wontUnlockBloquedExecution(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return formerExecutionStatus == BLOCKED && formerStepStatus != BLOCKED;
    }

    protected boolean mayUnlockBloquedExecution(ExecutionStatus formerStepStatus) {
        return this != BLOCKED && formerStepStatus == BLOCKED;
    }

    protected boolean couldHaveSetExecStatusAlone(ExecutionStatus formerExecutionStatus, ExecutionStatus formerStepStatus) {
        return formerExecutionStatus == formerStepStatus;
    }

    public static ExecutionStatus fromString(String status) {
        ExecutionStatus[] executionStatusArray = ExecutionStatus.values();
        int n = executionStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionStatus executionStatus = executionStatusArray[n2];
            if (executionStatus.name().equalsIgnoreCase(status)) {
                return executionStatus;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No enum constant " + ExecutionStatus.class.getName() + "." + status);
    }

    public static enum Conclusiveness implements Level
    {
        SUCCESS(1),
        FAILURE(2),
        NON_CONCLUSIVE(3);

        private final int level;

        private Conclusiveness(int level) {
            this.level = level;
        }

        public String getI18nKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public static Conclusiveness fromExecutionStatus(ExecutionStatus executionStatus) {
            return executionStatus.getConclusiveness();
        }

        public static boolean concludeToSuccess(ExecutionStatus executionStatus) {
            return executionStatus.getConclusiveness() == SUCCESS;
        }
    }

    public static enum Termination implements Level
    {
        TERMINAL(1),
        NON_TERMINAL(2);

        private final int level;

        private Termination(int level) {
            this.level = level;
        }

        public String getI18nKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public static Termination fromExecutionStatus(ExecutionStatus executionStatus) {
            ExecutionStatus canonicalStatus = executionStatus.getCanonicalStatus();
            if (canonicalStatus.isTerminatedStatus()) {
                return TERMINAL;
            }
            return NON_TERMINAL;
        }
    }
}

