/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.event.AbstractRequirementPropertyChangeEventBuilder;
import org.squashtest.tm.domain.event.ChangedProperty;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.event.RequirementPropertyChangeEventBuilder;
import org.squashtest.tm.domain.event.RequirementVersionModification;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Entity
@PrimaryKeyJoinColumn(name="EVENT_ID")
public class RequirementLargePropertyChange
extends RequirementAuditEvent
implements RequirementVersionModification,
ChangedProperty {
    @NotNull
    @Size(max=100)
    private @NotNull @Size(max=100) String propertyName;
    @Lob
    @JdbcTypeCode(value=-1)
    @Basic(fetch=FetchType.LAZY)
    private String oldValue;
    @Lob
    @JdbcTypeCode(value=-1)
    @Basic(fetch=FetchType.LAZY)
    private String newValue;

    public RequirementLargePropertyChange() {
    }

    public RequirementLargePropertyChange(RequirementVersion requirementVersion, String author) {
        super(requirementVersion, author);
    }

    public static RequirementPropertyChangeEventBuilder<RequirementLargePropertyChange> builder() {
        return new Builder();
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getOldValue() {
        return this.oldValue;
    }

    @Override
    public String getNewValue() {
        return this.newValue;
    }

    @Override
    public void accept(RequirementAuditEventVisitor visitor) {
        visitor.visit(this);
    }

    private static class Builder
    extends AbstractRequirementPropertyChangeEventBuilder<RequirementLargePropertyChange> {
        private Builder() {
        }

        @Override
        public RequirementLargePropertyChange build() {
            RequirementLargePropertyChange event = new RequirementLargePropertyChange(this.eventSource, this.author);
            event.propertyName = this.modifiedProperty;
            event.oldValue = HTMLSanitizeUtils.cleanHtml((String)this.valueToString(this.oldValue));
            event.newValue = HTMLSanitizeUtils.cleanHtml((String)this.valueToString(this.newValue));
            return event;
        }

        private String valueToString(Object oldValue) {
            return Objects.toString(oldValue, "");
        }
    }
}

