/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.event;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.requirement.RequirementVersion;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class RequirementAuditEvent {
    @Id
    @Column(name="EVENT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="requirement_audit_event_event_id_seq")
    @SequenceGenerator(name="requirement_audit_event_event_id_seq", sequenceName="requirement_audit_event_event_id_seq", allocationSize=30)
    private Long id;
    @ManyToOne
    @JoinColumn(name="REQ_VERSION_ID")
    @NotNull
    private RequirementVersion requirementVersion;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column(name="EVENT_DATE")
    private Date date;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String author;

    protected RequirementAuditEvent() {
    }

    protected RequirementAuditEvent(RequirementVersion requirementVersion, String author) {
        this.requirementVersion = requirementVersion;
        this.author = author;
        this.date = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public RequirementVersion getRequirementVersion() {
        return this.requirementVersion;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public abstract void accept(RequirementAuditEventVisitor var1);
}

