/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.environmentvariable;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;

@Entity
public class EnvironmentVariableBinding
implements Identified {
    @Id
    @Column(name="EVB_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="environment_variable_binding_evb_id_seq")
    @SequenceGenerator(name="environment_variable_binding_evb_id_seq", sequenceName="environment_variable_binding_evb_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=EnvironmentVariable.class)
    @JoinColumn(name="EV_ID", updatable=false)
    @NotNull
    private EnvironmentVariable environmentVariable;
    @NotNull
    private Long entityId;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private EVBindableEntity entityType;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String value = "";

    public EnvironmentVariableBinding() {
    }

    public EnvironmentVariableBinding(EnvironmentVariable environmentVariable, Long entityId, EVBindableEntity entityType) {
        this.environmentVariable = environmentVariable;
        this.entityId = entityId;
        this.entityType = entityType;
    }

    public EnvironmentVariableBinding(EnvironmentVariable environmentVariable, Long entityId, EVBindableEntity entityType, String value) {
        this.environmentVariable = environmentVariable;
        this.entityId = entityId;
        this.entityType = entityType;
        this.value = value;
    }

    public void updateValue(String value) {
        this.environmentVariable.checkValueMatchPattern(value);
        this.setValue(value);
    }

    public EnvironmentVariable getEnvironmentVariable() {
        return this.environmentVariable;
    }

    public void setEnvironmentVariable(EnvironmentVariable environmentVariable) {
        this.environmentVariable = environmentVariable;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public EVBindableEntity getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EVBindableEntity entityType) {
        this.entityType = entityType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Long getId() {
        return this.id;
    }
}

