/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValueDto;

@Entity
@DiscriminatorValue(value="NUM")
public class DenormalizedNumericValue
extends DenormalizedFieldValue {
    private BigDecimal numericValue;

    public DenormalizedNumericValue() {
    }

    public DenormalizedNumericValue(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        this.customFieldValue = customFieldValue;
        CustomField cuf = customFieldValue.getCustomField();
        this.code = cuf.getCode();
        this.inputType = cuf.getInputType();
        this.label = cuf.getLabel();
        this.value = customFieldValue.getValue();
        this.setNumericValuePrivately();
        this.position = customFieldValue.getBinding().getPosition();
        this.denormalizedFieldHolderId = denormalizedFieldHolderId;
        this.denormalizedFieldHolderType = denormalizedFieldHolderType;
    }

    public DenormalizedNumericValue(DenormalizedFieldValueDto denormalizedFieldValueDto) {
        super(denormalizedFieldValueDto);
        this.setNumericValuePrivately();
    }

    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
    }

    public void setNumericValue() {
        this.setNumericValuePrivately();
    }

    private void setNumericValuePrivately() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            this.numericValue = null;
        } else {
            BigDecimal bigDecimal;
            String formattedDefaultValue = this.value.replace(",", ".");
            this.numericValue = bigDecimal = new BigDecimal(formattedDefaultValue);
        }
    }
}

