/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.denormalizedfield;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValueDto;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldVisitor;

@NamedQueries(value={@NamedQuery(name="DenormalizedFieldValue.deleteAllForEntity", query="delete DenormalizedFieldValue dfv where dfv.denormalizedFieldHolderId = :entityId and dfv.denormalizedFieldHolderType = :entityType"), @NamedQuery(name="DenormalizedFieldValue.deleteAllForEntities", query="delete DenormalizedFieldValue dfv where dfv.denormalizedFieldHolderId in (:entityIds) and dfv.denormalizedFieldHolderType = :entityType"), @NamedQuery(name="DenormalizedFieldValue.findDFVForEntity", query="from DenormalizedFieldValue dfv where dfv.denormalizedFieldHolderId = :entityId and dfv.denormalizedFieldHolderType = :entityType order by dfv.position"), @NamedQuery(name="DenormalizedFieldValue.findDFVForEntities", query="select dfv from DenormalizedFieldValue dfv where dfv.denormalizedFieldHolderId in (:entityIds) and dfv.denormalizedFieldHolderType = :entityType order by dfv.position"), @NamedQuery(name="DenormalizedFieldValue.countDenormalizedFields", query="select count(dfv) from DenormalizedFieldValue dfv where dfv.denormalizedFieldHolderId = ?1 and dfv.denormalizedFieldHolderType = ?2")})
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="CF")
public class DenormalizedFieldValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DenormalizedFieldValue.class);
    @Id
    @Column(name="DFV_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="denormalized_field_value_dfv_id_seq")
    @SequenceGenerator(name="denormalized_field_value_dfv_id_seq", sequenceName="denormalized_field_value_dfv_id_seq", allocationSize=1)
    protected Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CFV_ID", nullable=true)
    protected CustomFieldValue customFieldValue;
    @NotBlank
    @Size(max=30)
    @Pattern(regexp="^[A-Za-z0-9_^;]*$")
    protected @NotBlank @Size(max=30) @Pattern(regexp="^[A-Za-z0-9_^;]*$") String code = "";
    protected Long denormalizedFieldHolderId;
    @Enumerated(value=EnumType.STRING)
    protected DenormalizedFieldHolderType denormalizedFieldHolderType;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    protected InputType inputType;
    @NotBlank
    @Size(max=255)
    protected @NotBlank @Size(max=255) String label = "";
    protected int position;
    @Size(max=255)
    protected @Size(max=255) String value;

    protected DenormalizedFieldValue() {
    }

    public DenormalizedFieldValue(CustomFieldValue customFieldValue, Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        this.customFieldValue = customFieldValue;
        CustomField cuf = customFieldValue.getCustomField();
        this.code = cuf.getCode();
        this.inputType = cuf.getInputType();
        this.label = cuf.getLabel();
        this.position = customFieldValue.getBinding().getPosition();
        this.denormalizedFieldHolderId = denormalizedFieldHolderId;
        this.denormalizedFieldHolderType = denormalizedFieldHolderType;
        this.value = customFieldValue.getValue();
    }

    public DenormalizedFieldValue(DenormalizedFieldValueDto denormalizedFieldValueDto) {
        this.customFieldValue = denormalizedFieldValueDto.customFieldValue();
        this.denormalizedFieldHolderId = denormalizedFieldValueDto.denormalizedFieldHolderId();
        this.denormalizedFieldHolderType = denormalizedFieldValueDto.denormalizedFieldHolderType();
        this.inputType = denormalizedFieldValueDto.inputType();
        this.position = denormalizedFieldValueDto.position();
        this.value = denormalizedFieldValueDto.value();
        Optional.ofNullable(denormalizedFieldValueDto.customFieldValue()).ifPresent(cfv -> {
            CustomFieldValue customFieldValue = this.customFieldValue = cfv;
        });
        Optional.ofNullable(denormalizedFieldValueDto.code()).ifPresent(c -> {
            String string = this.code = c;
        });
        Optional.ofNullable(denormalizedFieldValueDto.label()).ifPresent(l -> {
            String string = this.label = l;
        });
    }

    public Long getId() {
        return this.id;
    }

    public CustomFieldValue getCustomFieldValue() {
        return this.customFieldValue;
    }

    public String getCode() {
        return this.code;
    }

    public Long getDenormalizedFieldHolderId() {
        return this.denormalizedFieldHolderId;
    }

    public DenormalizedFieldHolderType getDenormalizedFieldHolderType() {
        return this.denormalizedFieldHolderType;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getLabel() {
        return this.label;
    }

    public int getPosition() {
        return this.position;
    }

    public String getValue() {
        return this.value;
    }

    public Date getValueAsDate() {
        Date toReturn = null;
        if (this.inputType == InputType.DATE_PICKER) {
            try {
                toReturn = DateUtils.parseIso8601Date((String)this.value);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return toReturn;
    }

    public void accept(DenormalizedFieldVisitor visitor) {
        visitor.visit(this);
    }

    public void setValue(String value) {
        this.value = value;
    }
}

