/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.tree.TreeEntityDefinition;

public enum CustomReportTreeDefinition implements TreeEntityDefinition
{
    LIBRARY(true, "LIBRARY"),
    DASHBOARD(false, "DASHBOARD"),
    CHART(false, "CHART"),
    FOLDER(true, "FOLDER"),
    REPORT(false, "REPORT"),
    CUSTOM_EXPORT(false, "CUSTOM_EXPORT");

    private boolean container;
    private final String typeIdentifier;

    private CustomReportTreeDefinition(boolean container, String typeIdentifier) {
        this.container = container;
        this.typeIdentifier = typeIdentifier;
    }

    @Override
    public String getTypeName() {
        return this.typeIdentifier;
    }

    @Override
    public boolean isContainer() {
        return this.container;
    }

    @Override
    public NodeType asNodeType() {
        return switch (this) {
            case CHART -> NodeType.CHART_DEFINITION;
            case FOLDER -> NodeType.CUSTOM_REPORT_FOLDER;
            case REPORT -> NodeType.REPORT_DEFINITION;
            case LIBRARY -> NodeType.CUSTOM_REPORT_LIBRARY;
            case DASHBOARD -> NodeType.CUSTOM_REPORT_DASHBOARD;
            case CUSTOM_EXPORT -> NodeType.CUSTOM_REPORT_CUSTOM_EXPORT;
            default -> throw new IllegalArgumentException("Unknown type for conversion to NodeType " + String.valueOf(this));
        };
    }
}

