/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class CustomReportFolder
implements CustomReportTreeEntity,
BoundEntity {
    @Id
    @Column(name="CRF_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="custom_report_folder_crf_id_seq")
    @SequenceGenerator(name="custom_report_folder_crf_id_seq", sequenceName="custom_report_folder_crf_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(max=255)
    @Column
    private @NotBlank @Size(max=255) String name;
    @Column
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void accept(CustomReportTreeEntityVisitor visitor) {
        visitor.visit(this);
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.project.getCustomReportLibrary();
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.CUSTOM_REPORT_FOLDER;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public AttachmentList getAttachmentList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public CustomReportTreeEntity createCopy() {
        CustomReportFolder copy = new CustomReportFolder();
        copy.setName(this.getName());
        copy.setDescription(this.getDescription());
        copy.setProject(this.getProject());
        return copy;
    }
}

