/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class CustomReportChartBinding
implements Identified {
    @Id
    @Column(name="CRCB_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="custom_report_chart_binding_crcb_id_seq")
    @SequenceGenerator(name="custom_report_chart_binding_crcb_id_seq", sequenceName="custom_report_chart_binding_crcb_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="CRD_ID", referencedColumnName="CRD_ID")
    private CustomReportDashboard dashboard;
    @ManyToOne
    @JoinColumn(name="CHART_ID", referencedColumnName="CHART_ID")
    private ChartDefinition chart;
    private int row;
    private int col;
    private int sizeX;
    private int sizeY;

    public CustomReportDashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(CustomReportDashboard dashboard) {
        this.dashboard = dashboard;
    }

    public ChartDefinition getChart() {
        return this.chart;
    }

    public void setChart(ChartDefinition chart) {
        this.chart = chart;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean hasMoved(CustomReportChartBinding transientBinding) {
        return this.hasMoveRow(transientBinding) || this.hasMoveCol(transientBinding) || this.hasMoveSizeX(transientBinding) || this.hasMoveSizeY(transientBinding);
    }

    public void move(CustomReportChartBinding transientBinding) {
        this.setRow(transientBinding.getRow());
        this.setCol(transientBinding.getCol());
        this.setSizeX(transientBinding.getSizeX());
        this.setSizeY(transientBinding.getSizeY());
    }

    @AclConstrainedObject
    public CustomReportLibrary getCustomReportLibrary() {
        return this.getDashboard().getProject().getCustomReportLibrary();
    }

    private boolean hasMoveSizeX(CustomReportChartBinding transientBinding) {
        return this.getSizeX() != transientBinding.getSizeX();
    }

    private boolean hasMoveSizeY(CustomReportChartBinding transientBinding) {
        return this.getSizeY() != transientBinding.getSizeY();
    }

    private boolean hasMoveCol(CustomReportChartBinding transientBinding) {
        return this.getRow() != transientBinding.getRow();
    }

    private boolean hasMoveRow(CustomReportChartBinding transientBinding) {
        return this.getCol() != transientBinding.getCol();
    }

    public CustomReportChartBinding createCopy() {
        CustomReportChartBinding copy = new CustomReportChartBinding();
        copy.setChart(this.getChart());
        copy.setDashboard(this.getDashboard());
        copy.move(this);
        return copy;
    }
}

