/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customreport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CampaignLibraryNode;
import org.squashtest.tm.jooq.domain.tables.Iteration;
import org.squashtest.tm.jooq.domain.tables.TestSuite;

public enum CustomExportColumnLabel implements Internationalizable
{
    CAMPAIGN_LABEL("label.Label", (Field<?>)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.NAME, (Field<?>)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_ID("label.id", (Field<?>)Tables.CAMPAIGN.CLN_ID, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_REFERENCE("label.Reference", (Field<?>)Tables.CAMPAIGN.REFERENCE, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_DESCRIPTION("label.Description", (Field<?>)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, (Field<?>)CampaignLibraryNode.CAMPAIGN_LIBRARY_NODE.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_STATE("label.State", (Field<?>)Tables.CAMPAIGN.CAMPAIGN_STATUS, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_PROGRESS_STATUS("campaign.progress_status.label", null, null, EntityType.CAMPAIGN),
    CAMPAIGN_MILESTONE("label.Milestone", (Field<?>)Tables.MILESTONE.as((String)"camp_milestone").LABEL, (Field<?>)Tables.MILESTONE.as((String)"camp_milestone").MILESTONE_ID, EntityType.CAMPAIGN),
    CAMPAIGN_SCHEDULED_START("dialog.label.campaign.scheduled_start.label", (Field<?>)Tables.CAMPAIGN.SCHEDULED_START_DATE, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_SCHEDULED_END("dialog.label.campaign.scheduled_end.label", (Field<?>)Tables.CAMPAIGN.SCHEDULED_END_DATE, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_ACTUAL_START("dialog.label.campaign.actual_start.label", (Field<?>)Tables.CAMPAIGN.ACTUAL_START_DATE, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_ACTUAL_END("dialog.label.campaign.actual_end.label", (Field<?>)Tables.CAMPAIGN.ACTUAL_END_DATE, (Field<?>)Tables.CAMPAIGN.CLN_ID, EntityType.CAMPAIGN),
    CAMPAIGN_CUF(null, null, null, EntityType.CAMPAIGN),
    ITERATION_LABEL("label.Label", (Field<?>)Iteration.ITERATION.NAME, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_ID("label.id", (Field<?>)Iteration.ITERATION.ITERATION_ID, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_REFERENCE("label.Reference", (Field<?>)Iteration.ITERATION.REFERENCE, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_DESCRIPTION("label.Description", (Field<?>)Iteration.ITERATION.DESCRIPTION, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_STATE("label.State", (Field<?>)Iteration.ITERATION.ITERATION_STATUS, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_SCHEDULED_START("dialog.label.campaign.scheduled_start.label", (Field<?>)Iteration.ITERATION.SCHEDULED_START_DATE, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_SCHEDULED_END("dialog.label.campaign.scheduled_end.label", (Field<?>)Iteration.ITERATION.SCHEDULED_END_DATE, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_ACTUAL_START("dialog.label.campaign.actual_start.label", (Field<?>)Iteration.ITERATION.ACTUAL_START_DATE, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_ACTUAL_END("dialog.label.campaign.actual_end.label", (Field<?>)Iteration.ITERATION.ACTUAL_END_DATE, (Field<?>)Iteration.ITERATION.ITERATION_ID, EntityType.ITERATION),
    ITERATION_CUF(null, null, null, EntityType.ITERATION),
    TEST_SUITE_LABEL("label.Label", (Field<?>)TestSuite.TEST_SUITE.NAME, (Field<?>)TestSuite.TEST_SUITE.ID, EntityType.TEST_SUITE),
    TEST_SUITE_ID("label.id", (Field<?>)TestSuite.TEST_SUITE.ID, (Field<?>)TestSuite.TEST_SUITE.ID, EntityType.TEST_SUITE),
    TEST_SUITE_DESCRIPTION("label.Description", (Field<?>)TestSuite.TEST_SUITE.DESCRIPTION, (Field<?>)TestSuite.TEST_SUITE.ID, EntityType.TEST_SUITE),
    TEST_SUITE_EXECUTION_STATUS("chart.column.EXECUTION_STATUS", (Field<?>)TestSuite.TEST_SUITE.EXECUTION_STATUS, (Field<?>)TestSuite.TEST_SUITE.ID, EntityType.TEST_SUITE),
    TEST_SUITE_PROGRESS_STATUS("test-suite.progress_status.label", Fields.TEST_SUITE_PROGRESS_STATUS, null, EntityType.TEST_SUITE),
    TEST_SUITE_CUF(null, null, (Field<?>)TestSuite.TEST_SUITE.ID, EntityType.TEST_SUITE),
    TEST_CASE_PROJECT("label.project", (Field<?>)Tables.PROJECT.NAME, (Field<?>)Tables.PROJECT.PROJECT_ID, EntityType.TEST_CASE),
    TEST_CASE_MILESTONE("label.Milestones", Fields.TEST_CASE_MILESTONE, null, EntityType.TEST_CASE),
    TEST_CASE_LABEL("label.Label", (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_ID("label.id", (Field<?>)Tables.TEST_CASE.TCLN_ID, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_REFERENCE("label.Reference", (Field<?>)Tables.TEST_CASE.REFERENCE, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_DESCRIPTION("label.Description", (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION, (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_STATUS("label.Status", (Field<?>)Tables.TEST_CASE.TC_STATUS, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_IMPORTANCE("label.Importance", (Field<?>)Tables.TEST_CASE.IMPORTANCE, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_NATURE("chart.column.TEST_CASE_NATURE", (Field<?>)Tables.INFO_LIST_ITEM.as((String)"type_nature").LABEL, (Field<?>)Tables.INFO_LIST_ITEM.as((String)"type_nature").ITEM_ID, EntityType.TEST_CASE),
    TEST_CASE_TYPE("label.Type", (Field<?>)Tables.INFO_LIST_ITEM.as((String)"type_list").LABEL, (Field<?>)Tables.INFO_LIST_ITEM.as((String)"type_list").ITEM_ID, EntityType.TEST_CASE),
    TEST_CASE_DATASET("label.dataset", (Field<?>)Tables.DATASET.NAME, (Field<?>)Tables.DATASET.DATASET_ID, EntityType.TEST_CASE),
    TEST_CASE_PREREQUISITE("generics.prerequisite.title", (Field<?>)Tables.TEST_CASE.PREREQUISITE, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    TEST_CASE_LINKED_REQUIREMENTS_NUMBER("custom-export.column.LINKED_REQUIREMENTS_COUNT", Fields.TEST_CASE_LINKED_REQUIREMENTS_NUMBER, null, EntityType.TEST_CASE),
    TEST_CASE_LINKED_REQUIREMENTS_IDS("custom-export.column.LINKED_REQUIREMENTS_IDS", Fields.TEST_CASE_LINKED_REQUIREMENTS_IDS, null, EntityType.TEST_CASE),
    TEST_CASE_CUF(null, null, (Field<?>)Tables.TEST_CASE.TCLN_ID, EntityType.TEST_CASE),
    EXECUTION_ID("label.id", (Field<?>)Tables.EXECUTION.EXECUTION_ID, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_EXECUTION_MODE("label.ExecutionMode", (Field<?>)Tables.EXECUTION.EXECUTION_MODE, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_STATUS("label.Status", (Field<?>)Tables.EXECUTION.EXECUTION_STATUS, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_SUCCESS_RATE("shortLabel.SuccessRate", Fields.EXECUTION_SUCCESS_RATE, null, EntityType.EXECUTION),
    EXECUTION_USER("label.User", (Field<?>)Tables.EXECUTION.LAST_EXECUTED_BY, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_EXECUTION_DATE("iteration.executions.table.column-header.execution-date.label", (Field<?>)Tables.EXECUTION.LAST_EXECUTED_ON, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_COMMENT("executions.steps.table.column-header.comment.label", (Field<?>)Tables.EXECUTION.DESCRIPTION, (Field<?>)Tables.EXECUTION.EXECUTION_ID, EntityType.EXECUTION),
    EXECUTION_CUF(null, null, null, EntityType.EXECUTION),
    EXECUTION_STEP_STEP_NUMBER("custom-export.column.EXECUTION_STEP.EXECUTION_STEP_NUMBER", (Field<?>)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER.add((Number)1), (Field<?>)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_ACTION("label.action", (Field<?>)Tables.EXECUTION_STEP.ACTION, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_RESULT("custom-export.column.EXECUTION_STEP.RESULT", (Field<?>)Tables.EXECUTION_STEP.EXPECTED_RESULT, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_STATUS("label.Status", (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STATUS, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_USER("label.User", (Field<?>)Tables.EXECUTION_STEP.LAST_EXECUTED_BY, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_EXECUTION_DATE("iteration.executions.table.column-header.execution-date.label", (Field<?>)Tables.EXECUTION_STEP.LAST_EXECUTED_ON, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_COMMENT("executions.steps.table.column-header.comment.label", (Field<?>)Tables.EXECUTION_STEP.COMMENT, (Field<?>)Tables.EXECUTION_STEP.EXECUTION_STEP_ID, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_LINKED_REQUIREMENTS_NUMBER("custom-export.column.LINKED_REQUIREMENTS_COUNT", Fields.EXECUTION_STEP_LINKED_REQUIREMENTS_NUMBER, null, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_LINKED_REQUIREMENTS_IDS("custom-export.column.EXECUTION_STEP_LINKED_REQUIREMENTS_IDS", Fields.EXECUTION_STEP_LINKED_REQUIREMENTS_IDS, null, EntityType.EXECUTION_STEP),
    EXECUTION_STEP_CUF(null, null, null, EntityType.EXECUTION_STEP),
    TEST_STEP_CUF(null, null, null, EntityType.TEST_STEP),
    ISSUE_EXECUTION_AND_EXECUTION_STEP_ISSUES_NUMBER("custom-export.wizard.attributes.ISSUE.ALL_LINKED_ISSUES_COUNT", Fields.ISSUE_EXECUTION_AND_EXECUTION_STEP_ISSUES_NUMBER, null, EntityType.ISSUE),
    ISSUE_EXECUTION_AND_EXECUTION_STEP_ISSUES_IDS("label.Execution", Fields.EXECUTION_AND_EXECUTION_STEP_ISSUES_KEYS, null, EntityType.ISSUE),
    ISSUE_EXECUTION_STEP_ISSUES_NUMBER("custom-export.wizard.attributes.ISSUE.STEP_LINKED_ISSUES_COUNT", Fields.ISSUE_EXECUTION_STEP_ISSUES_NUMBER, null, EntityType.ISSUE),
    ISSUE_EXECUTION_STEP_ISSUES_IDS("chart.entityType.EXECUTION_STEP", Fields.ISSUE_EXECUTION_STEP_ISSUES_IDS, null, EntityType.ISSUE);

    private static final Map<EntityType, TableField<?, Long>> TREE_SELECTABLE_ENTITY_TYPE_MAP;
    private static final Set<CustomExportColumnLabel> CUSTOMIZABLE_TEXT_FIELDS_SET;
    private static final Map<EntityType, TableField<?, Long>> ENTITY_TYPE_TO_ID_TABLE_FIELD_MAP;
    private static final Set<CustomExportColumnLabel> RICH_TEXT_FIELDS_SET;
    private static final String SUITE_ITPI_DONE = "suite_itpi_done";
    private static final String SUITE_ITPI_TOTAL = "suite_itpi_total";
    private static final String EXEC_STEP_DONE = "exec_step_done";
    private static final String EXEC_STEP_TOTAL = "exec_step_total";
    private String i18nKey;
    private Field<?> jooqTableField;
    private Field<?> jooqTablePkField;
    private EntityType entityType;

    static {
        HashSet<CustomExportColumnLabel> initialSet = new HashSet<CustomExportColumnLabel>();
        initialSet.addAll(Arrays.asList(CAMPAIGN_LABEL, CAMPAIGN_REFERENCE, CAMPAIGN_DESCRIPTION, CAMPAIGN_MILESTONE, CAMPAIGN_CUF, ITERATION_LABEL, ITERATION_REFERENCE, ITERATION_DESCRIPTION, ITERATION_CUF, TEST_SUITE_LABEL, TEST_SUITE_DESCRIPTION, TEST_SUITE_CUF, TEST_CASE_PROJECT, TEST_CASE_MILESTONE, TEST_CASE_LABEL, TEST_CASE_REFERENCE, TEST_CASE_DESCRIPTION, TEST_CASE_NATURE, TEST_CASE_TYPE, TEST_CASE_DATASET, TEST_CASE_PREREQUISITE, TEST_CASE_CUF, EXECUTION_USER, EXECUTION_COMMENT, EXECUTION_CUF, EXECUTION_STEP_ACTION, EXECUTION_STEP_RESULT, EXECUTION_STEP_USER, EXECUTION_STEP_COMMENT, EXECUTION_STEP_CUF, TEST_STEP_CUF));
        CUSTOMIZABLE_TEXT_FIELDS_SET = Collections.unmodifiableSet(initialSet);
        HashMap<EntityType, Object> initialMap = new HashMap<EntityType, Object>(7);
        initialMap.put(EntityType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
        initialMap.put(EntityType.ITERATION, Tables.ITERATION.ITERATION_ID);
        initialMap.put(EntityType.TEST_SUITE, Tables.TEST_SUITE.ID);
        initialMap.put(EntityType.TEST_CASE, Tables.TEST_CASE.TCLN_ID);
        initialMap.put(EntityType.EXECUTION, Tables.EXECUTION.EXECUTION_ID);
        initialMap.put(EntityType.EXECUTION_STEP, Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
        initialMap.put(EntityType.TEST_STEP, Tables.EXECUTION_STEP.EXECUTION_STEP_ID);
        ENTITY_TYPE_TO_ID_TABLE_FIELD_MAP = Collections.unmodifiableMap(initialMap);
        initialMap = new HashMap(4);
        initialMap.put(EntityType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
        initialMap.put(EntityType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
        initialMap.put(EntityType.ITERATION, Iteration.ITERATION.ITERATION_ID);
        initialMap.put(EntityType.TEST_SUITE, TestSuite.TEST_SUITE.ID);
        TREE_SELECTABLE_ENTITY_TYPE_MAP = Collections.unmodifiableMap(initialMap);
        initialSet = new HashSet(9);
        initialSet.add(CAMPAIGN_DESCRIPTION);
        initialSet.add(ITERATION_DESCRIPTION);
        initialSet.add(TEST_SUITE_DESCRIPTION);
        initialSet.add(TEST_CASE_DESCRIPTION);
        initialSet.add(TEST_CASE_PREREQUISITE);
        initialSet.add(EXECUTION_COMMENT);
        initialSet.add(EXECUTION_STEP_COMMENT);
        initialSet.add(EXECUTION_STEP_ACTION);
        initialSet.add(EXECUTION_STEP_RESULT);
        RICH_TEXT_FIELDS_SET = Collections.unmodifiableSet(initialSet);
    }

    private CustomExportColumnLabel(String i18nKey, Field<?> jooqTableField, Field<?> jooqTablePkField, EntityType entityType) {
        this.i18nKey = i18nKey;
        this.jooqTableField = jooqTableField;
        this.jooqTablePkField = jooqTablePkField;
        this.entityType = entityType;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public Field<?> getJooqTableField() {
        return this.jooqTableField;
    }

    public Field<?> getJooqTablePkField() {
        return this.jooqTablePkField;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getShortenedEntityType() {
        return ShortenedNames.getShortenedEntityType(this.entityType);
    }

    public static Set<CustomExportColumnLabel> getRichTextFieldsSet() {
        return RICH_TEXT_FIELDS_SET;
    }

    public static Map<EntityType, TableField<?, Long>> getEntityTypeToIdTableFieldMap() {
        return ENTITY_TYPE_TO_ID_TABLE_FIELD_MAP;
    }

    public static Map<EntityType, TableField<?, Long>> getSelectableEntityTypeToIdTableFieldMap() {
        return TREE_SELECTABLE_ENTITY_TYPE_MAP;
    }

    public static Set<CustomExportColumnLabel> getCustomizableTextFieldsSet() {
        return CUSTOMIZABLE_TEXT_FIELDS_SET;
    }

    private static final class Fields {
        private static final Field<Double> FIELD_TEST_SUITE_ITPI_DONE_COUNT = DSL.select((SelectField)DSL.count(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).cast(SQLDataType.DOUBLE)).from((TableLike)TestSuite.TEST_SUITE.as("suite_itpi_done")).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq(TestSuite.TEST_SUITE.as((String)"suite_itpi_done").ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(TestSuite.TEST_SUITE.as((String)"suite_itpi_done").ID.eq(TestSuite.TEST_SUITE.ID)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.in((Object[])new String[]{"SETTLED", "UNTESTABLE", "BLOCKED", "FAILURE", "SUCCESS"})).asField();
        private static final Field<Double> FIELD_TEST_SUITE_ITPI_TOTAL_COUNT = DSL.select((SelectField)DSL.count(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).cast(SQLDataType.DOUBLE)).from((TableLike)TestSuite.TEST_SUITE.as("suite_itpi_total")).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq(TestSuite.TEST_SUITE.as((String)"suite_itpi_total").ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID)).where(TestSuite.TEST_SUITE.as((String)"suite_itpi_total").ID.eq(TestSuite.TEST_SUITE.ID)).asField();
        private static final Field<String> TEST_SUITE_PROGRESS_STATUS = DSL.concat((Field[])new Field[]{DSL.round((Field)FIELD_TEST_SUITE_ITPI_DONE_COUNT.div(DSL.nullif(FIELD_TEST_SUITE_ITPI_TOTAL_COUNT, (Field)DSL.val((double)0.0))).mul((Number)100L), (int)2).cast(SQLDataType.VARCHAR((int)5)), DSL.val((String)" "), DSL.val((String)"%")});
        private static final Field<Double> FIELD_EXECUTION_STEP_SUCCESS_COUNT = DSL.select((SelectField)DSL.count(Tables.EXECUTION_STEP.EXECUTION_STEP_ID).cast(SQLDataType.DOUBLE)).from((TableLike)Tables.EXECUTION.as("exec_step_done")).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(Tables.EXECUTION.as((String)"exec_step_done").EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).where(Tables.EXECUTION.as((String)"exec_step_done").EXECUTION_ID.eq(Tables.EXECUTION.EXECUTION_ID)).and(Tables.EXECUTION_STEP.EXECUTION_STATUS.eq((Object)"SUCCESS")).asField();
        private static final Field<Double> FIELD_EXECUTION_STEP_TOTAL_COUNT = DSL.select((SelectField)DSL.count(Tables.EXECUTION_STEP.EXECUTION_STEP_ID).cast(SQLDataType.DOUBLE)).from((TableLike)Tables.EXECUTION.as("exec_step_total")).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(Tables.EXECUTION.as((String)"exec_step_total").EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)).where(Tables.EXECUTION.as((String)"exec_step_total").EXECUTION_ID.eq(Tables.EXECUTION.EXECUTION_ID)).asField();
        private static final Field<String> EXECUTION_SUCCESS_RATE = DSL.concat((Field[])new Field[]{DSL.round((Field)FIELD_EXECUTION_STEP_SUCCESS_COUNT.div(DSL.nullif(FIELD_EXECUTION_STEP_TOTAL_COUNT, (Field)DSL.val((double)0.0))).mul((Number)100L), (int)2).cast(SQLDataType.VARCHAR((int)5)), DSL.val((String)" "), DSL.val((String)"%")});
        private static final Field<String> EXECUTION_AND_EXECUTION_STEP_ISSUES_KEYS = DSL.select((SelectField)DSL.groupConcatDistinct(Tables.ISSUE.REMOTE_ISSUE_ID).separator(", ").as("exec_and_es_issue_ids")).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq(Tables.ISSUE.ISSUE_ID)).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq(Tables.EXECUTION.EXECUTION_ID)).asField();
        private static final Field<Integer> ISSUE_EXECUTION_AND_EXECUTION_STEP_ISSUES_NUMBER = DSL.select((SelectField)DSL.countDistinct(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq(Tables.EXECUTION.EXECUTION_ID)).asField("exec_and_es_issue_number");
        private static final Field<Integer> ISSUE_EXECUTION_STEP_ISSUES_NUMBER = DSL.select((SelectField)DSL.countDistinct(Tables.ISSUE.ISSUE_ID)).from((TableLike)Tables.ISSUE).where(Tables.ISSUE.ISSUE_LIST_ID.eq(Tables.EXECUTION_STEP.ISSUE_LIST_ID)).asField("es_issue_number");
        private static final Field<String> ISSUE_EXECUTION_STEP_ISSUES_IDS = DSL.select((SelectField)DSL.groupConcatDistinct(Tables.ISSUE.REMOTE_ISSUE_ID).separator(", ")).from((TableLike)Tables.ISSUE).where(Tables.ISSUE.ISSUE_LIST_ID.eq(Tables.EXECUTION_STEP.ISSUE_LIST_ID)).asField("es_issue_ids");
        private static final Field<Integer> EXECUTION_STEP_LINKED_REQUIREMENTS_NUMBER = DSL.select((SelectField)DSL.countDistinct(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).innerJoin((TableLike)Tables.VERIFYING_STEPS).on(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID.eq(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID)).where(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq(Tables.EXECUTION_STEP.TEST_STEP_ID)).asField("es_rvc_number");
        private static final Field<String> EXECUTION_STEP_LINKED_REQUIREMENTS_IDS = DSL.select((SelectField)DSL.groupConcatDistinct(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(", ")).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).innerJoin((TableLike)Tables.VERIFYING_STEPS).on(Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID.eq(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID)).where(Tables.VERIFYING_STEPS.TEST_STEP_ID.eq(Tables.EXECUTION_STEP.TEST_STEP_ID)).asField("es_rvc_ids");
        private static final Field<Integer> TEST_CASE_LINKED_REQUIREMENTS_NUMBER = DSL.select((SelectField)DSL.countDistinct(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID)).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(Tables.TEST_PLAN_ITEM.TCLN_ID)).asField("tc_rvc_number");
        private static final Field<String> TEST_CASE_LINKED_REQUIREMENTS_IDS = DSL.select((SelectField)DSL.groupConcatDistinct(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).separator(", ")).from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq(Tables.TEST_PLAN_ITEM.TCLN_ID)).asField("tc_rvc_ids");
        private static final Field<String> TEST_CASE_MILESTONE = DSL.select((SelectField)DSL.groupConcatDistinct(Tables.MILESTONE.LABEL).separator(", ")).from((TableLike)Tables.MILESTONE).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq(Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq(Tables.TEST_PLAN_ITEM.TCLN_ID)).asField("tc_milestone_labels");

        private Fields() {
        }
    }

    private static final class I18nKeys {
        private static final String I18N_KEY_ACTUAL_END = "dialog.label.campaign.actual_end.label";
        private static final String I18N_KEY_ACTUAL_START = "dialog.label.campaign.actual_start.label";
        private static final String I18N_KEY_LINKED_REQUIREMENTS_NUMBER = "custom-export.column.LINKED_REQUIREMENTS_COUNT";
        private static final String I18N_KEY_CUSTOM_EXPORT_COLUMN_LINKED_REQUIREMENTS_IDS = "custom-export.column.LINKED_REQUIREMENTS_IDS";
        private static final String I18N_KEY_DESCRIPTION = "label.Description";
        private static final String I18N_KEY_ID = "label.id";
        private static final String I18N_KEY_LABEL = "label.Label";
        private static final String I18N_KEY_MILESTONE = "label.Milestone";
        private static final String I18N_KEY_MILESTONES = "label.Milestones";
        private static final String I18N_KEY_PROGRESS_STATUS = "campaign.progress_status.label";
        private static final String I18N_KEY_REFERENCE = "label.Reference";
        private static final String I18N_KEY_SCHEDULED_END = "dialog.label.campaign.scheduled_end.label";
        private static final String I18N_KEY_SCHEDULED_START = "dialog.label.campaign.scheduled_start.label";
        private static final String I18N_KEY_STATE = "label.State";
        private static final String I18N_KEY_STATUS = "label.Status";
        private static final String I18N_KEY_USER = "label.User";

        private I18nKeys() {
        }
    }

    private static final class ShortenedNames {
        private static final Map<EntityType, String> ENTITY_TYPE_TO_SHORTEN_ENTITY_NAME_MAP;

        static {
            HashMap<EntityType, String> initialMap = new HashMap<EntityType, String>(7);
            initialMap.put(EntityType.CAMPAIGN, "CPG");
            initialMap.put(EntityType.ITERATION, "IT");
            initialMap.put(EntityType.TEST_SUITE, "SUI");
            initialMap.put(EntityType.TEST_CASE, "TC");
            initialMap.put(EntityType.EXECUTION, "EXEC");
            initialMap.put(EntityType.EXECUTION_STEP, "EXEC_STEP");
            initialMap.put(EntityType.ISSUE, "BUG");
            initialMap.put(EntityType.TEST_STEP, "TEST_STEP");
            ENTITY_TYPE_TO_SHORTEN_ENTITY_NAME_MAP = Collections.unmodifiableMap(initialMap);
        }

        private ShortenedNames() {
        }

        private static String getShortenedEntityType(EntityType entityType) {
            return ENTITY_TYPE_TO_SHORTEN_ENTITY_NAME_MAP.get((Object)entityType);
        }
    }
}

