/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueOption;
import org.squashtest.tm.domain.customfield.CustomFieldValueVisitor;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.MultiValuedCustomFieldValue;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.exception.customfield.MandatoryCufException;

@Entity
@DiscriminatorValue(value="TAG")
public class TagsValue
extends CustomFieldValue
implements MultiValuedCustomFieldValue,
CustomFieldVisitor {
    @ElementCollection
    @CollectionTable(name="CUSTOM_FIELD_VALUE_OPTION", joinColumns={@JoinColumn(name="CFV_ID")})
    @OrderColumn(name="POSITION")
    private List<CustomFieldValueOption> selectedOptions = new ArrayList<CustomFieldValueOption>();

    @Override
    public List<CustomFieldValueOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    public void addCUFieldValueOption(CustomFieldValueOption cufVO) {
        this.selectedOptions.add(cufVO);
    }

    public void removeCUFValueOption(CustomFieldValueOption cufVO) {
        this.selectedOptions.remove(cufVO);
    }

    @Override
    public void setValues(List<String> values) {
        CustomField cuf = this.getCustomField();
        if (cuf != null) {
            if (!cuf.isOptional() && values.isEmpty()) {
                throw new MandatoryCufException(this);
            }
            this.selectedOptions.clear();
            for (String option : values) {
                this.selectedOptions.add(new CustomFieldValueOption(option));
            }
            this.getCustomField().accept(this);
        }
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> result = new ArrayList<String>(this.selectedOptions.size());
        for (CustomFieldValueOption option : this.selectedOptions) {
            result.add(option.getLabel());
        }
        return result;
    }

    @Override
    public String getValue() {
        return this.selectedOptions.isEmpty() ? "" : StringUtils.join(this.getValues(), (String)"|");
    }

    @Override
    @Deprecated
    public void setValue(String value) {
        this.setValues(value == null ? Collections.emptyList() : Arrays.asList(value.split("\\|")));
    }

    @Override
    public CustomFieldValue copy() {
        TagsValue copy = new TagsValue();
        copy.setBinding(this.getBinding());
        copy.setCufId(this.binding.getCustomField().getId());
        for (CustomFieldValueOption option : this.selectedOptions) {
            copy.addCUFieldValueOption(option.copy());
        }
        return copy;
    }

    @Override
    public RawValue asRawValue() {
        return new RawValue(this.getValues());
    }

    @Override
    public void setSelectedOptions(List<CustomFieldValueOption> options) {
        this.selectedOptions = options;
    }

    @Override
    public void visit(SingleSelectField selectField) {
        throw new IllegalArgumentException("a TAG custom field value cannot represent a Single Select Field");
    }

    @Override
    public void visit(CustomField standardValue) {
        throw new IllegalArgumentException("a TAG custom field value cannot represent a standard custom field");
    }

    @Override
    public void visit(RichTextField richField) {
        throw new IllegalArgumentException("a TAG custom field value cannot represent a Rich Text field");
    }

    @Override
    public void visit(NumericField numericField) {
        throw new IllegalArgumentException("a TAG custom field value cannot represent a Numeric custom field");
    }

    @Override
    public void visit(MultiSelectField multiselect) {
        for (CustomFieldValueOption option : this.selectedOptions) {
            multiselect.addOption(option.getLabel());
        }
    }

    @Override
    public void accept(CustomFieldValueVisitor visitor) {
        visitor.visit(this);
    }
}

