/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldValueVisitor;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.exception.customfield.MandatoryCufException;
import org.squashtest.tm.exception.customfield.WrongCufNumericFormatException;

@Entity
@DiscriminatorValue(value="NUM")
public class NumericCustomFieldValue
extends CustomFieldValue {
    private BigDecimal numericValue;

    @Override
    public void setValue(String value) {
        CustomField field = this.getCustomField();
        if (field != null && !field.isOptional() && StringUtils.isBlank((CharSequence)value)) {
            throw new MandatoryCufException(this);
        }
        if (field != null && field.isOptional() && StringUtils.isBlank((CharSequence)value)) {
            this.numericValue = null;
            this.value = "";
        } else {
            try {
                String normalizedValue = value.replace(",", ".");
                this.numericValue = new BigDecimal(normalizedValue);
                this.value = this.numericValue.toPlainString();
            }
            catch (NumberFormatException nfe) {
                throw new WrongCufNumericFormatException(nfe);
            }
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CustomFieldValue copy() {
        NumericCustomFieldValue copy = new NumericCustomFieldValue();
        copy.setBinding(this.getBinding());
        ((CustomFieldValue)copy).setValue(this.getValue());
        copy.setCufId(this.binding.getCustomField().getId());
        return copy;
    }

    @Override
    public void accept(CustomFieldValueVisitor visitor) {
        visitor.visit(this);
    }

    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    @Override
    public RawValue asRawValue() {
        return new RawValue(this.value);
    }
}

