/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;

@Entity
@DiscriminatorValue(value="MSF")
public class MultiSelectField
extends CustomField {
    public static final String SEPARATOR = "|";
    public static final String SEPARATOR_EXPR = "\\|";
    @ElementCollection
    @CollectionTable(name="CUSTOM_FIELD_OPTION", joinColumns={@JoinColumn(name="CF_ID")})
    private Set<CustomFieldOption> options = new HashSet<CustomFieldOption>();

    public MultiSelectField() {
        super(InputType.TAG);
    }

    public Set<CustomFieldOption> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    @Override
    public void accept(CustomFieldVisitor visitor) {
        visitor.visit(this);
    }

    public void addOption(String label) {
        CustomFieldOption newOption = new CustomFieldOption(label);
        this.options.add(newOption);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        String[] values;
        String[] stringArray = values = defaultValue.split(SEPARATOR_EXPR);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.addOption(v);
            ++n2;
        }
        this.defaultValue = defaultValue;
    }
}

