/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.NumericCustomFieldValue;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.customfield.TagsValue;
import org.squashtest.tm.domain.project.GenericProject;

@Entity
public class CustomFieldBinding
implements Identified {
    @Id
    @Column(name="CFB_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="custom_field_binding_cfb_id_seq")
    @SequenceGenerator(name="custom_field_binding_cfb_id_seq", sequenceName="custom_field_binding_cfb_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER, optional=false, targetEntity=CustomField.class, cascade={CascadeType.DETACH})
    @JoinColumn(name="CF_ID", updatable=false)
    @NotNull
    private CustomField customField;
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    private BindableEntity boundEntity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BOUND_PROJECT_ID", updatable=false)
    @NotNull
    private GenericProject boundProject;
    @Column
    private int position = 0;

    public CustomField getCustomField() {
        return this.customField;
    }

    public void setCustomField(CustomField customField) {
        this.customField = customField;
    }

    public BindableEntity getBoundEntity() {
        return this.boundEntity;
    }

    public void setBoundEntity(BindableEntity boundEntity) {
        this.boundEntity = boundEntity;
    }

    public GenericProject getBoundProject() {
        return this.boundProject;
    }

    public void setBoundProject(GenericProject boundProject) {
        this.boundProject = boundProject;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public CustomFieldValue createNewValue() {
        CustomFieldValue value = switch (this.customField.getInputType()) {
            case InputType.RICH_TEXT -> new RichTextValue();
            case InputType.TAG -> new TagsValue();
            case InputType.NUMERIC -> new NumericCustomFieldValue();
            case InputType.DROPDOWN_LIST -> new CustomFieldValue();
            default -> new CustomFieldValue();
        };
        value.setBinding(this);
        value.setValue(this.customField.getDefaultValue());
        value.setCufId(this.customField.getId());
        return value;
    }

    public static class PositionAwareBindingList
    extends LinkedList<CustomFieldBinding> {
        private static final long serialVersionUID = 1L;

        public PositionAwareBindingList(Collection<CustomFieldBinding> items) {
            super(items);
        }

        public void reorderItems(List<Long> itemIds, int newIndex) {
            this.moveCarelessly(itemIds, newIndex);
            this.reindex();
        }

        private void moveCarelessly(List<Long> ids, int newIndex) {
            HashSet<Long> targetIds = new HashSet<Long>(ids);
            LinkedList<CustomFieldBinding> removed = new LinkedList<CustomFieldBinding>();
            ListIterator iterator = this.listIterator();
            while (iterator.hasNext()) {
                CustomFieldBinding binding = (CustomFieldBinding)iterator.next();
                Long id = binding.getId();
                if (!targetIds.contains(id)) continue;
                removed.add(binding);
                iterator.remove();
                targetIds.remove(id);
            }
            this.addAll(newIndex, removed);
        }

        private void reindex() {
            int position = 1;
            for (CustomFieldBinding binding : this) {
                binding.setPosition(position++);
            }
        }
    }
}

