/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.customfield;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.text.ParseException;
import java.util.Date;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.validation.constraint.HasDefaultAsRequired;

@NamedQueries(value={@NamedQuery(name="CustomField.findAllOrderedByName", query="from CustomField cf order by cf.name"), @NamedQuery(name="CustomField.countCustomFields", query="select count(*) from CustomField"), @NamedQuery(name="CustomField.findByCode", query="from CustomField where code = ?1")})
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="FIELD_TYPE", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="CF")
@HasDefaultAsRequired
public class CustomField
implements Identified {
    public static final String CODE_REGEXP = "^[A-Za-z0-9_^;]*$";
    public static final String OPTION_REGEXP = "^[A-Za-z0-9_]*$";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomField.class);
    @Id
    @Column(name="CF_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="custom_field_cf_id_seq")
    @SequenceGenerator(name="custom_field_cf_id_seq", sequenceName="custom_field_cf_id_seq", allocationSize=1)
    protected Long id;
    @NotBlank
    @Size(max=255)
    protected @NotBlank @Size(max=255) String name;
    @NotBlank
    @Size(max=255)
    protected @NotBlank @Size(max=255) String label = "";
    protected boolean optional = true;
    @Size(max=255)
    protected @Size(max=255) String defaultValue;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(updatable=false)
    protected InputType inputType = InputType.PLAIN_TEXT;
    @NotBlank
    @Size(max=30)
    @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}")
    protected @NotBlank @Size(max=30) @Pattern(regexp="^[A-Za-z0-9_^;]*$", message="{org.squashtest.tm.validation.constraint.onlyStdChars}") String code = "";

    protected CustomField() {
    }

    public CustomField(@NotNull InputType inputType) {
        this.inputType = inputType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isOptional() {
        if (this.inputType == InputType.CHECKBOX) {
            return false;
        }
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        String dValue = defaultValue;
        if (this.inputType == InputType.DATE_PICKER) {
            try {
                DateUtils.parseIso8601Date((String)defaultValue);
            }
            catch (ParseException parseException) {
                dValue = "";
            }
        }
        this.defaultValue = dValue;
    }

    public Date getDefaultValueAsDate() {
        if (this.inputType == InputType.DATE_PICKER) {
            try {
                return DateUtils.parseIso8601Date((String)this.defaultValue);
            }
            catch (ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void accept(CustomFieldVisitor visitor) {
        visitor.visit(this);
    }
}

