/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.chart;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Entity
@Table(name="CHART_FILTER")
public class Filter
implements QueryColumnPrototypeInstance {
    @Id
    @Column(name="FILTER_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="chart_filter_filter_id_seq")
    @SequenceGenerator(name="chart_filter_filter_id_seq", sequenceName="chart_filter_filter_id_seq", allocationSize=1)
    private Long id;
    @JoinColumn(name="CHART_COLUMN_ID")
    @ManyToOne
    private QueryColumnPrototype column;
    @Enumerated(value=EnumType.STRING)
    @Column(name="FILTER_OPERATION")
    private Operation operation;
    @ElementCollection
    @CollectionTable(name="CHART_FILTER_VALUES", joinColumns={@JoinColumn(name="FILTER_ID")})
    @Column(name="FILTER_VALUE")
    private List<String> values = new ArrayList<String>();
    private Long cufId;

    @Override
    public QueryColumnPrototype getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumnPrototype column) {
        this.column = column;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public EntityType getEntityType() {
        return this.column.getEntityType();
    }

    @Override
    public SpecializedEntityType getSpecializedType() {
        return this.column.getSpecializedType();
    }

    @Override
    public DataType getDataType() {
        return this.column.getDataType();
    }

    @Override
    public Long getCufId() {
        return this.cufId;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    public Filter createCopy() {
        Filter copy = new Filter();
        copy.setColumn(this.getColumn());
        copy.setOperation(this.getOperation());
        copy.getValues().addAll(this.getValues());
        copy.setCufId(this.getCufId());
        return copy;
    }

    public Long getId() {
        return this.id;
    }
}

