/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.chart;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryColumnPrototypeInstance;
import org.squashtest.tm.domain.query.SpecializedEntityType;

@Embeddable
@Table(name="CHART_AXIS_COLUMN")
public class AxisColumn
implements QueryColumnPrototypeInstance {
    @NotBlank
    @Size(max=30)
    private @NotBlank @Size(max=30) String label;
    @JoinColumn(name="CHART_COLUMN_ID")
    @ManyToOne
    private QueryColumnPrototype column;
    @Enumerated(value=EnumType.STRING)
    @Column(name="AXIS_OPERATION")
    private Operation operation;
    private Long cufId;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public QueryColumnPrototype getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumnPrototype column) {
        this.column = column;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public EntityType getEntityType() {
        return this.column.getEntityType();
    }

    @Override
    public SpecializedEntityType getSpecializedType() {
        return this.column.getSpecializedType();
    }

    @Override
    public DataType getDataType() {
        return this.column.getDataType();
    }

    @Override
    public Long getCufId() {
        return this.cufId;
    }

    public void setCufId(Long cufId) {
        this.cufId = cufId;
    }

    public AxisColumn createCopy() {
        AxisColumn copy = new AxisColumn();
        copy.setColumn(this.getColumn());
        copy.setOperation(this.getOperation());
        copy.setCufId(this.getCufId());
        copy.setLabel(this.getLabel());
        return copy;
    }
}

