/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign.testplan;

import java.util.Date;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;

public record TestPlanItemDto(TestPlan testPlan, ExecutionStatus executionStatus, String label, User assignee, String createdBy, Date createdOn, String lastModifiedBy, Date lastModifiedOn, String lastExecutedBy, Date lastExecutedOn, TestCase referencedTestCase, Dataset referencedDataset, ExploratorySessionOverview exploratorySessionOverview, String key) {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TestPlan testPlan;
        private ExecutionStatus executionStatus;
        private String label;
        private User assignee;
        private String createdBy;
        private Date createdOn;
        private String lastModifiedBy;
        private Date lastModifiedOn;
        private String lastExecutedBy;
        private Date lastExecutedOn;
        private TestCase referencedTestCase;
        private Dataset referencedDataset;
        private ExploratorySessionOverview exploratorySessionOverview;
        private String key;

        private Builder() {
        }

        public Builder withTestPlan(TestPlan testPlan) {
            this.testPlan = testPlan;
            return this;
        }

        public Builder withExecutionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withAssignee(User assignee) {
            this.assignee = assignee;
            return this;
        }

        public Builder withCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder withCreatedOn(Date createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public Builder withLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder withLastModifiedOn(Date lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public Builder withLastExecutedBy(String lastExecutedBy) {
            this.lastExecutedBy = lastExecutedBy;
            return this;
        }

        public Builder withLastExecutedOn(Date lastExecutedOn) {
            this.lastExecutedOn = lastExecutedOn;
            return this;
        }

        public Builder withReferencedTestCase(TestCase referencedTestCase) {
            this.referencedTestCase = referencedTestCase;
            return this;
        }

        public Builder withReferencedDataset(Dataset referencedDataset) {
            this.referencedDataset = referencedDataset;
            return this;
        }

        public Builder withExploratorySessionOverview(ExploratorySessionOverview exploratorySessionOverview) {
            this.exploratorySessionOverview = exploratorySessionOverview;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public TestPlanItemDto build() {
            return new TestPlanItemDto(this.testPlan, this.executionStatus, this.label, this.assignee, this.createdBy, this.createdOn, this.lastModifiedBy, this.lastModifiedOn, this.lastExecutedBy, this.lastExecutedOn, this.referencedTestCase, this.referencedDataset, this.exploratorySessionOverview, this.key);
        }
    }
}

