/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign.testplan;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.common.ordered.OrderedListHelper;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class TestPlan
implements Identified {
    @Id
    @Column(name="TEST_PLAN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="test_plan_test_plan_id_seq")
    @SequenceGenerator(name="test_plan_test_plan_id_seq", sequenceName="test_plan_test_plan_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CL_ID")
    private CampaignLibrary campaignLibrary;
    @OneToMany(mappedBy="testPlan", cascade={CascadeType.ALL})
    @OrderBy(value="itemOrder")
    private List<TestPlanItem> testPlanItems = new ArrayList<TestPlanItem>();
    @OneToOne(mappedBy="testPlan", cascade={CascadeType.ALL})
    private Iteration parentIteration;

    public TestPlan(CampaignLibrary campaignLibrary) {
        this.campaignLibrary = campaignLibrary;
    }

    protected TestPlan() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setCampaignLibrary(CampaignLibrary campaignLibrary) {
        this.campaignLibrary = campaignLibrary;
    }

    public void clear() {
        this.testPlanItems.clear();
    }

    public TestPlanItem createAndAddTestPlanItem(TestCase testCase, Dataset dataset, User assignee) {
        TestPlanItem createdItem = new TestPlanItem(this, testCase, dataset);
        createdItem.setAssignee(assignee);
        this.addItem(createdItem, null);
        return createdItem;
    }

    public List<TestPlanItem> createAndAddTestPlanItems(List<TestCase> testCasesToAdd) {
        ArrayList<TestPlanItem> createdItems = new ArrayList<TestPlanItem>();
        for (TestCase testCase : testCasesToAdd) {
            Set<Dataset> datasets = testCase.getDatasets();
            if (datasets == null || datasets.isEmpty()) {
                createdItems.add(new TestPlanItem(this, testCase));
                continue;
            }
            List<TestPlanItem> items = testCase.getDatasets().stream().map(dataSet -> new TestPlanItem(this, testCase, (Dataset)dataSet)).toList();
            createdItems.addAll(items);
        }
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addAllContent(createdItems, null);
        return createdItems;
    }

    public void createAndAddTestPlanItems(Map<TestCase, List<Dataset>> datasetsByTestCase) {
        ArrayList<TestPlanItem> createdItems = new ArrayList<TestPlanItem>();
        for (Map.Entry<TestCase, List<Dataset>> entry : datasetsByTestCase.entrySet()) {
            TestCase testCase = entry.getKey();
            List<Dataset> datasets = entry.getValue();
            if (datasets == null || datasets.isEmpty()) {
                createdItems.add(new TestPlanItem(this, testCase));
                continue;
            }
            List<TestPlanItem> items = datasets.stream().map(dataSet -> new TestPlanItem(this, testCase, (Dataset)dataSet)).toList();
            createdItems.addAll(items);
        }
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addAllContent(createdItems, null);
    }

    public void removeTestPlanItem(TestPlanItem itemToRemove) {
        this.testPlanItems.remove(itemToRemove);
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).reorder();
        for (TestSuite testSuite : itemToRemove.getTestSuites()) {
            testSuite.getTestPlanItems().remove(itemToRemove);
        }
    }

    public List<TestPlanItem> getTestPlanItems() {
        return Collections.unmodifiableList(this.testPlanItems);
    }

    public List<Execution> getAllExecutions() {
        return this.testPlanItems.stream().flatMap(item -> item.getExecutions().stream()).toList();
    }

    public GenericProject getProject() {
        return this.campaignLibrary.getProject();
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.campaignLibrary;
    }

    public void moveItems(List<TestPlanItem> items, int position) {
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).moveContent(items, (Integer)position);
    }

    public void copyItems(TestPlan source) {
        List<TestPlanItem> itemsToCopy = source.getTestPlanItems().stream().filter(item -> item.getReferencedTestCase() != null).map(item -> item.createCopy(this)).toList();
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addAllContent(itemsToCopy, null);
    }

    public List<TestPlanItem> copyItems(List<TestPlanItem> itemsToCopy) {
        List<TestPlanItem> copiedItems = itemsToCopy.stream().filter(item -> item.getReferencedTestCase() != null).map(item -> item.createCopy(this)).toList();
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addAllContent(copiedItems, null);
        return copiedItems;
    }

    public boolean equalsById(TestPlan other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.id != null && other.getId() != null) {
            return this.id.equals(other.getId());
        }
        return false;
    }

    public void addTransientItems(List<TestPlanItem> filteredTestPLan) {
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addAllContent(filteredTestPLan, null);
    }

    public void addItem(TestPlanItem testPlanItem, Integer position) {
        new OrderedListHelper<TestPlanItem>(this.testPlanItems).addContent(testPlanItem, position);
    }

    public Iteration getParentIteration() {
        return this.parentIteration;
    }

    public void setParentIteration(Iteration iteration) {
        this.parentIteration = iteration;
    }
}

