/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.execution.EmptySprintReqVersionTestPlanException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.security.annotation.InheritsAcls;

@Entity
@Table(name="SPRINT_REQ_VERSION")
@InheritsAcls(constrainedClass=Sprint.class, collectionName="sprintReqVersions")
@Auditable
public class SprintReqVersion
extends BaseAuditableEntity
implements Identified,
TestPlanOwner {
    @Id
    @Column(name="SPRINT_REQ_VERSION_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sprint_req_version_sprint_req_version_id_seq")
    @SequenceGenerator(name="sprint_req_version_sprint_req_version_id_seq", sequenceName="sprint_req_version_sprint_req_version_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="REQ_VERSION_ID", referencedColumnName="RES_ID")
    private RequirementVersion requirementVersion;
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="SPRINT_ID", referencedColumnName="CLN_ID")
    private Sprint sprint;
    @Column(name="REFERENCE")
    @Size(max=50)
    private @Size(max=50) String reference;
    @Column(name="NAME")
    @Size(max=255)
    private @Size(max=255) String name;
    @Column(name="STATUS")
    @Size(max=50)
    private @Size(max=50) String status;
    @Column(name="VALIDATION_STATUS")
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private SprintReqVersionValidationStatus validationStatus = SprintReqVersionValidationStatus.TO_BE_TESTED;
    @Column(name="CRITICALITY")
    @Size(max=50)
    private @Size(max=50) String criticality;
    @Column(name="CATEGORY")
    @Size(max=50)
    private @Size(max=50) String category;
    @Column(name="DESCRIPTION")
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @Column
    @Enumerated(value=EnumType.STRING)
    private ManagementMode mode = ManagementMode.NATIVE;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_PLAN_ID", referencedColumnName="TEST_PLAN_ID")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private TestPlan testPlan;

    public SprintReqVersion() {
    }

    public SprintReqVersion(Sprint sprint) {
        this.sprint = sprint;
        this.testPlan = new TestPlan(sprint.getCampaignLibrary());
    }

    public SprintReqVersion(RequirementVersion requirementVersion, Sprint sprint) {
        this.requirementVersion = requirementVersion;
        this.sprint = sprint;
        this.testPlan = new TestPlan(sprint.getProject().getCampaignLibrary());
        this.testPlan.createAndAddTestPlanItems(requirementVersion.getOrderedVerifyingTestCases());
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Project getProject() {
        if (this.sprint != null) {
            return this.sprint.getProject();
        }
        return null;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RequirementVersion getRequirementVersion() {
        return this.requirementVersion;
    }

    public void setRequirementVersion(RequirementVersion requirementVersion) {
        this.requirementVersion = requirementVersion;
    }

    public Sprint getSprint() {
        return this.sprint;
    }

    public void setSprint(Sprint sprint) {
        this.sprint = sprint;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public SprintReqVersionValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(SprintReqVersionValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public String getCriticality() {
        return this.criticality;
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = HTMLSanitizeUtils.cleanHtml((String)description);
    }

    public ManagementMode getMode() {
        return this.mode;
    }

    public void setMode(ManagementMode mode) {
        this.mode = mode;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void setTestPlan(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public SprintReqVersion createCopy(Sprint parentSprint) {
        SprintReqVersion copy = new SprintReqVersion(parentSprint);
        copy.setRequirementVersion(this.requirementVersion);
        if (Objects.isNull(this.requirementVersion)) {
            copy.setReference(this.reference);
            copy.setName(this.name);
            copy.setCriticality(this.criticality);
            copy.setCategory(this.category);
            copy.setStatus(this.status);
        }
        copy.setSprint(parentSprint);
        copy.setDescription(this.description);
        copy.setMode(ManagementMode.NATIVE);
        copy.testPlan.copyItems(this.testPlan);
        return copy;
    }

    public void migrateTestPlan() {
        this.testPlan.setCampaignLibrary(this.sprint.getCampaignLibrary());
    }

    @Override
    public List<TestPlanItem> getTestPlanItems() {
        return this.testPlan.getTestPlanItems();
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId) {
        return this.findNextExecutableTestPlanItem(testPlanItemId, null);
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId, String testerLogin) {
        List<TestPlanItem> remainingTestPlanItems = this.getRemainingItemsByItemId(testPlanItemId);
        for (TestPlanItem item : remainingTestPlanItems) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin) || !item.isExecutable()) continue;
            return item;
        }
        throw new TestPlanItemNotExecutableException("No more executable item in this iteration's test plan");
    }

    private List<TestPlanItem> getRemainingItemsByItemId(long testPlanItemId) {
        List<TestPlanItem> items = this.getTestPlanItems();
        int i = 0;
        while (i < items.size()) {
            if (testPlanItemId == items.get(i).getId()) {
                return items.subList(i + 1, items.size());
            }
            ++i;
        }
        throw new IllegalArgumentException("The item with id %s does not belong to the test plan of the sprint with id %s".formatted(testPlanItemId, this.getId()));
    }

    @Override
    public TestPlanItem findFirstExecutableTestPlanItem(String testerLogin) {
        TestPlanItem firstTestPlanItem = this.getFirstTestPlanItem(testerLogin);
        if (firstTestPlanItem.isExecutable()) {
            return firstTestPlanItem;
        }
        return this.findNextExecutableTestPlanItem(firstTestPlanItem.getId(), testerLogin);
    }

    private TestPlanItem getFirstTestPlanItem(String testerLogin) {
        for (TestPlanItem item : this.getTestPlanItems()) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin)) continue;
            return item;
        }
        throw new EmptySprintReqVersionTestPlanException(this.id);
    }
}

