/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryNodeVisitor;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.SprintGroupContainer;
import org.squashtest.tm.domain.library.SprintGroupSupport;
import org.squashtest.tm.exception.DuplicateNameException;

@Entity
@PrimaryKeyJoinColumn(name="CLN_ID")
public class SprintGroup
extends CampaignLibraryNode
implements SprintGroupContainer<CampaignLibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SprintGroup.class);
    @Column(name="REMOTE_SYNCHRONISATION_ID")
    private Long remoteSynchronisationId;
    @Transient
    private final SprintGroupSupport<CampaignLibraryNode, SprintGroup> sprintGroupSupport = new SprintGroupSupport(this);
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="CLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID")})
    private List<CampaignLibraryNode> content = new ArrayList<CampaignLibraryNode>();

    @Override
    public void addContent(CampaignLibraryNode node) throws DuplicateNameException, NullArgumentException {
        CampaignLibraryNode campaignLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignLibraryNode);
        this.sprintGroupSupport.addContent(node);
    }

    @Override
    public void addContent(CampaignLibraryNode node, int position) throws DuplicateNameException, NullArgumentException {
        CampaignLibraryNode campaignLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignLibraryNode);
        this.sprintGroupSupport.addContent(node, position);
        this.content = new ArrayList<CampaignLibraryNode>(this.content);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.sprintGroupSupport.isContentNameAvailable(name);
    }

    @Override
    public List<CampaignLibraryNode> getContent() {
        return this.content;
    }

    @Override
    public Collection<CampaignLibraryNode> getOrderedContent() {
        return this.content;
    }

    @Override
    public boolean hasContent() {
        return this.sprintGroupSupport.hasContent();
    }

    @Override
    public void removeContent(CampaignLibraryNode contentToRemove) throws NullArgumentException {
        this.content.remove(contentToRemove);
        this.content = new ArrayList<CampaignLibraryNode>(this.content);
        LOGGER.info(this.content.toString(), new Object[0]);
    }

    @Override
    public List<String> getContentNames() {
        return this.sprintGroupSupport.getContentNames();
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(CampaignLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.SPRINT_GROUP, this.getId());
    }

    @Override
    public SprintGroup createCopy() {
        return this.sprintGroupSupport.createCopy(new SprintGroup());
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.SPRINT_GROUP;
    }

    public boolean isSynchronized() {
        return Objects.nonNull(this.remoteSynchronisationId);
    }
}

