/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.campaign.ActualTimePeriod;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CascadingAutoDateComparatorBuilder;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.campaign.ScheduledTimePeriod;
import org.squashtest.tm.domain.campaign.TestPlanOwner;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.library.Copiable;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneMember;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.execution.EmptyIterationTestPlanException;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Auditable
@Entity
public class Iteration
extends BaseAuditableEntity
implements AttachmentHolder,
NodeContainer<TestSuite>,
TreeNode,
Copiable,
Identified,
BoundEntity,
MilestoneMember,
TestPlanOwner {
    private static final String ITERATION_ID = "ITERATION_ID";
    public static final String FULL_NAME_SEPARATOR = " - ";
    public static final String SIMPLE_CLASS_NAME = "org.squashtest.tm.domain.campaign.Iteration";
    @Id
    @Column(name="ITERATION_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="iteration_iteration_id_seq")
    @SequenceGenerator(name="iteration_iteration_id_seq", sequenceName="iteration_iteration_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @JdbcTypeCode(value=-1)
    private String description;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String reference = "";
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="ITERATION_STATUS")
    private IterationStatus status = IterationStatus.UNDEFINED;
    @Embedded
    @Valid
    private ScheduledTimePeriod scheduledPeriod = new ScheduledTimePeriod();
    @Embedded
    @Valid
    private final ActualTimePeriod actualPeriod = new ActualTimePeriod();
    @NotNull
    @Column(name="UUID")
    @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}")
    private @NotNull @Pattern(regexp="[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}") String uuid;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CAMPAIGN_ITERATION", joinColumns={@JoinColumn(name="ITERATION_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="CAMPAIGN_ID", updatable=false, insertable=false)})
    private Campaign campaign;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_PLAN_ID", referencedColumnName="TEST_PLAN_ID")
    @Cascade(value={CascadeType.ALL})
    private final TestPlan testPlan;
    @OneToOne(cascade={jakarta.persistence.CascadeType.PERSIST, jakarta.persistence.CascadeType.MERGE, jakarta.persistence.CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @OneToMany(cascade={jakarta.persistence.CascadeType.PERSIST, jakarta.persistence.CascadeType.MERGE})
    @OrderColumn(name="ITERATION_TEST_SUITE_ORDER")
    @JoinTable(name="ITERATION_TEST_SUITE", joinColumns={@JoinColumn(name="ITERATION_ID")}, inverseJoinColumns={@JoinColumn(name="TEST_SUITE_ID")})
    private List<TestSuite> testSuites = new ArrayList<TestSuite>();
    @OneToMany(mappedBy="iteration", cascade={jakarta.persistence.CascadeType.REMOVE})
    private List<AutomatedSuite> automatedSuites = new ArrayList<AutomatedSuite>();

    public Iteration() {
        UUID newUUID = UUID.randomUUID();
        this.uuid = newUUID.toString();
        this.testPlan = new TestPlan(null);
        this.testPlan.setParentIteration(this);
    }

    @Override
    public List<TestPlanItem> getTestPlanItems() {
        return this.testPlan.getTestPlanItems();
    }

    public List<Execution> getExecutions() {
        return this.testPlan.getAllExecutions();
    }

    @Override
    public void setName(String name) {
        this.name = name.trim();
    }

    @Override
    @NotBlank
    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public IterationStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull IterationStatus status) {
        IterationStatus iterationStatus = status;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)iterationStatus);
        this.status = status;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    void setCampaign(Campaign campaign) {
        this.campaign = campaign;
        this.testPlan.setCampaignLibrary(campaign.getCampaignLibrary());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setScheduledStartDate(Date startDate) {
        this.getScheduledPeriod().setScheduledStartDate(startDate);
    }

    public Date getScheduledStartDate() {
        return this.getScheduledPeriod().getScheduledStartDate();
    }

    public void setScheduledEndDate(Date endDate) {
        this.getScheduledPeriod().setScheduledEndDate(endDate);
    }

    public Date getScheduledEndDate() {
        return this.getScheduledPeriod().getScheduledEndDate();
    }

    public void setActualStartDate(Date startDate) {
        this.actualPeriod.setActualStartDate(startDate);
        if (this.getCampaign() != null) {
            this.getCampaign().updateActualStart(startDate);
        }
    }

    public Date getActualStartDate() {
        return this.actualPeriod.getActualStartDate();
    }

    public void setActualEndDate(Date endDate) {
        this.actualPeriod.setActualEndDate(endDate);
        if (this.getCampaign() != null) {
            this.getCampaign().updateActualEnd(endDate);
        }
    }

    public Date getActualEndDate() {
        return this.actualPeriod.getActualEndDate();
    }

    public boolean isActualStartAuto() {
        return this.actualPeriod.isActualStartAuto();
    }

    public boolean isActualEndAuto() {
        return this.actualPeriod.isActualEndAuto();
    }

    public void setActualStartAuto(boolean actualStartAuto) {
        this.actualPeriod.setActualStartAuto(actualStartAuto);
        if (this.actualPeriod.isActualStartAuto()) {
            this.autoSetActualStartDate();
        }
    }

    public void setActualEndAuto(boolean actualEndAuto) {
        this.actualPeriod.setActualEndAuto(actualEndAuto);
        if (this.actualPeriod.isActualEndAuto()) {
            this.autoSetActualEndDate();
        }
    }

    public void setUnsafeActualPeriod(boolean actualStartAuto, boolean actualEndAuto, Date actualStartDate, Date actualEndDate) {
        this.actualPeriod.setActualStartAuto(actualStartAuto);
        this.actualPeriod.setActualEndAuto(actualEndAuto);
        this.actualPeriod.setActualStartDate(actualStartDate);
        this.actualPeriod.setActualEndDate(actualEndDate);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    private ScheduledTimePeriod getScheduledPeriod() {
        if (this.scheduledPeriod == null) {
            this.scheduledPeriod = new ScheduledTimePeriod();
        }
        return this.scheduledPeriod;
    }

    @Override
    public Iteration createCopy() {
        Iteration clone = new Iteration();
        clone.setName(this.getName());
        clone.setDescription(this.getDescription());
        clone.setReference(this.getReference());
        this.copyPlanning(clone);
        clone.testPlan.copyItems(this.testPlan);
        clone.testPlan.setCampaignLibrary(this.testPlan.getCampaignLibrary());
        for (Attachment attach : this.getAttachmentList().getAllAttachments()) {
            Attachment copyAttach = attach.shallowCopy();
            clone.getAttachmentList().addAttachment(copyAttach);
        }
        Map<TestSuite, List<Integer>> testSuitesPastableCopiesMap = this.createTestSuitesPastableCopy();
        List<TestSuite> copiedTestSuites = clone.getTestSuites();
        for (Map.Entry<TestSuite, List<Integer>> entry : testSuitesPastableCopiesMap.entrySet()) {
            TestSuite testSuiteCopy = entry.getKey();
            copiedTestSuites.add(testSuiteCopy);
            ArrayList<TestPlanItem> testPlanItemsToBind = new ArrayList<TestPlanItem>();
            List<TestPlanItem> iterationTestPlanCopy = clone.getTestPlan().getTestPlanItems();
            for (Integer testSuiteTpiIndexInIterationList : entry.getValue()) {
                TestPlanItem testPlanItemToBind = iterationTestPlanCopy.get(testSuiteTpiIndexInIterationList);
                testPlanItemsToBind.add(testPlanItemToBind);
            }
            List<TestPlanItem> testSuiteTestPlan = testSuiteCopy.getTestPlanItems();
            testSuiteTestPlan.addAll(testPlanItemsToBind);
        }
        return clone;
    }

    private void copyPlanning(Iteration clone) {
        clone.setActualEndAuto(this.isActualEndAuto());
        clone.setActualStartAuto(this.isActualStartAuto());
        if (this.getScheduledStartDate() != null) {
            clone.setScheduledStartDate((Date)this.getScheduledStartDate().clone());
        }
        if (this.getScheduledEndDate() != null) {
            clone.setScheduledEndDate((Date)this.getScheduledEndDate().clone());
        }
    }

    List<TestCase> getPlannedTestCase() {
        return this.testPlan.getTestPlanItems().stream().map(TestPlanItem::getReferencedTestCase).filter(Objects::nonNull).toList();
    }

    public void moveTestSuites(int newIndex, List<TestSuite> movedItems) {
        if (!this.testSuites.isEmpty()) {
            this.testSuites.removeAll(movedItems);
            this.testSuites.addAll(newIndex, movedItems);
        }
    }

    public void removeTestSuite(@NotNull TestSuite testSuite) {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.testSuites.remove(testSuite);
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId) {
        return this.findNextExecutableTestPlanItem(testPlanItemId, null);
    }

    @Override
    public TestPlanItem findNextExecutableTestPlanItem(long testPlanItemId, String testerLogin) {
        List<TestPlanItem> remaining = this.getRemainingPlanById(testPlanItemId);
        for (TestPlanItem item : remaining) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin) || !item.isExecutable()) continue;
            return item;
        }
        throw new TestPlanItemNotExecutableException("No more executable item in this iteration's test plan");
    }

    @Override
    public TestPlanItem findFirstExecutableTestPlanItem(String testerLogin) {
        TestPlanItem firstTestPlanItem = this.getFirstTestPlanItem(testerLogin);
        if (firstTestPlanItem.isExecutable()) {
            return firstTestPlanItem;
        }
        return this.findNextExecutableTestPlanItem(firstTestPlanItem.getId(), testerLogin);
    }

    private TestPlanItem getFirstTestPlanItem(String testerLogin) {
        for (TestPlanItem item : this.testPlan.getTestPlanItems()) {
            if (testerLogin != null && !item.isAssignedToUser(testerLogin)) continue;
            return item;
        }
        throw new EmptyIterationTestPlanException(this);
    }

    private List<TestPlanItem> getRemainingPlanById(long testPlanItemId) {
        List<TestPlanItem> items = this.testPlan.getTestPlanItems();
        int i = 0;
        while (i < items.size()) {
            if (testPlanItemId == items.get(i).getId()) {
                return items.subList(i + 1, items.size());
            }
            ++i;
        }
        throw new IllegalArgumentException("Item[%d] does not belong to test plan of Iteration[%d]".formatted(testPlanItemId, this.id));
    }

    public List<TestSuite> getTestSuites() {
        return this.testSuites;
    }

    @UsedInPlugin(value="campaign-assistant")
    public TestSuite getTestSuiteByName(String tsName) {
        for (TestSuite ts : this.testSuites) {
            if (!ts.getName().equals(tsName)) continue;
            return ts;
        }
        throw new NoSuchElementException("Iteration " + String.valueOf(this.id) + " : cannot find test suite named '" + tsName + "'");
    }

    private void addTestSuite(TestSuite suite) {
        if (!this.checkSuiteNameAvailable(suite.getName())) {
            throw new DuplicateNameException("cannot add suite to iteration " + this.getName() + " : suite named " + suite.getName() + " already exists");
        }
        this.testSuites.add(suite);
    }

    private void addTestSuite(TestSuite suite, int position) {
        if (!this.checkSuiteNameAvailable(suite.getName())) {
            throw new DuplicateNameException("cannot add suite to iteration " + this.getName() + " : suite named " + suite.getName() + " already exists");
        }
        this.testSuites.add(position, suite);
    }

    public boolean checkSuiteNameAvailable(String name) {
        for (TestSuite suite : this.testSuites) {
            if (!suite.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    @Override
    public Project getProject() {
        if (this.campaign != null) {
            return this.campaign.getProject();
        }
        return null;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.getProject().getCampaignLibrary();
    }

    public void updateAutoDates(Date newItemTestPlanDate) {
        if (this.isActualStartAuto()) {
            this.updateAutoDatesActualStart(newItemTestPlanDate);
        }
        if (this.isActualEndAuto()) {
            this.updateAutoDatesActualEnd(newItemTestPlanDate);
        }
    }

    private void updateAutoDatesActualEnd(Date newItemTestPlanDate) {
        if (this.hasOnlyTerminatedTestPlanItems()) {
            if (this.getActualEndDate() == null) {
                this.setActualEndDate(newItemTestPlanDate);
            } else if (newItemTestPlanDate != null && this.getActualEndDate().compareTo(newItemTestPlanDate) < 0) {
                this.setActualEndDate(newItemTestPlanDate);
            } else {
                this.autoSetActualEndDateNoCheck();
            }
        } else {
            this.setActualEndDate(null);
        }
    }

    private void updateAutoDatesActualStart(Date newItemTestPlanDate) {
        if (this.getActualStartDate() == null) {
            this.setActualStartDate(newItemTestPlanDate);
        } else if (newItemTestPlanDate != null && this.getActualStartDate().compareTo(newItemTestPlanDate) > 0) {
            this.setActualStartDate(newItemTestPlanDate);
        } else {
            this.autoSetActualStartDate();
        }
    }

    private void autoSetActualStartDate() {
        Date actualDate = this.getFirstExecutedTestPlanDate();
        this.setActualStartDate(actualDate);
    }

    private void autoSetActualEndDateNoCheck() {
        Date actualDate = this.getLastExecutedTestPlanDate();
        this.setActualEndDate(actualDate);
    }

    private void autoSetActualEndDate() {
        Date actualDate = null;
        if (this.hasOnlyTerminatedTestPlanItems()) {
            actualDate = this.getLastExecutedTestPlanDate();
        }
        this.setActualEndDate(actualDate);
    }

    private boolean hasOnlyTerminatedTestPlanItems() {
        for (TestPlanItem testPlanItem : this.testPlan.getTestPlanItems()) {
            if (testPlanItem.getExecutionStatus().isTerminatedStatus()) continue;
            return false;
        }
        return true;
    }

    private Date getFirstExecutedTestPlanDate() {
        if (this.getTestPlanItems().isEmpty()) {
            return null;
        }
        TestPlanItem firstTestPlan = Collections.min(this.getTestPlanItems(), CascadingAutoDateComparatorBuilder.buildTestPlanFirstDateSorter());
        return firstTestPlan.getLastExecutedOn();
    }

    private Date getLastExecutedTestPlanDate() {
        if (this.getTestPlanItems().isEmpty()) {
            return null;
        }
        TestPlanItem lastTestPlan = Collections.max(this.getTestPlanItems(), CascadingAutoDateComparatorBuilder.buildTestPlanLastDateSorter());
        return lastTestPlan.getLastExecutedOn();
    }

    public Map<TestSuite, List<Integer>> createTestSuitesPastableCopy() {
        HashMap<TestSuite, List<Integer>> resultMap = new HashMap<TestSuite, List<Integer>>();
        List<TestPlanItem> testPlanWithoutDeletedTestCases = this.getTestPlanWithoutDeletedTestCases();
        for (TestSuite testSuite : this.getTestSuites()) {
            List<TestPlanItem> testSuiteTestPlan = testSuite.getTestPlanItems();
            TestSuite testSuiteCopy = testSuite.createCopy();
            ArrayList<Integer> testPlanIndex = new ArrayList<Integer>();
            for (TestPlanItem item : testSuiteTestPlan) {
                int testPlanItemIndex = testPlanWithoutDeletedTestCases.indexOf(item);
                if (testPlanItemIndex <= -1) continue;
                testPlanIndex.add(testPlanItemIndex);
            }
            resultMap.put(testSuiteCopy, testPlanIndex);
        }
        return resultMap;
    }

    private List<TestPlanItem> getTestPlanWithoutDeletedTestCases() {
        return this.getTestPlan().getTestPlanItems().stream().filter(item -> !item.isTestCaseDeleted()).toList();
    }

    public void updateAutoDatesAfterExecutionDetach(TestPlanItem testPlanItem) {
        this.updateAutoEndDateAfterExecutionDetach(testPlanItem);
        this.updateStartAutoDateAfterExecutionDetach();
    }

    private void updateStartAutoDateAfterExecutionDetach() {
        if (this.isActualStartAuto()) {
            this.autoSetActualStartDate();
        }
    }

    private void updateAutoEndDateAfterExecutionDetach(TestPlanItem testPlanItem) {
        if (this.isActualEndAuto()) {
            if (!testPlanItem.getExecutionStatus().isTerminatedStatus()) {
                this.setActualEndDate(null);
            } else {
                this.autoSetActualEndDate();
            }
        }
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.ITERATION;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addContent(@NotNull TestSuite testSuite) throws DuplicateNameException, NullArgumentException {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.addTestSuite(testSuite);
        testSuite.setIteration(this);
    }

    @Override
    public void addContent(@NotNull TestSuite testSuite, int position) throws DuplicateNameException, NullArgumentException {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.addTestSuite(testSuite, position);
        testSuite.setIteration(this);
    }

    @Override
    public void addContentWithoutSet(@NotNull TestSuite testSuite) throws DuplicateNameException, NullArgumentException {
        TestSuite testSuite2 = testSuite;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testSuite2);
        this.addTestSuite(testSuite);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.checkSuiteNameAvailable(name);
    }

    @Override
    public List<TestSuite> getContent() {
        return this.getTestSuites();
    }

    @Override
    public Collection<TestSuite> getOrderedContent() {
        return this.getTestSuites();
    }

    @Override
    public boolean hasContent() {
        return !this.getContent().isEmpty();
    }

    @Override
    public void removeContent(TestSuite contentToRemove) throws NullArgumentException {
        this.removeTestSuite(contentToRemove);
    }

    @Override
    public List<String> getContentNames() {
        ArrayList<String> testSuitesNames = new ArrayList<String>(this.testSuites.size());
        for (TestSuite suite : this.testSuites) {
            testSuitesNames.add(suite.getName());
        }
        return testSuitesNames;
    }

    @Override
    public Set<Milestone> getMilestones() {
        return this.getCampaign().getMilestones();
    }

    @Override
    public boolean isMemberOf(Milestone milestone) {
        return this.getCampaign().isMemberOf(milestone);
    }

    @Override
    public Boolean doMilestonesAllowCreation() {
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectCreateAndDelete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean doMilestonesAllowEdition() {
        for (Milestone m : this.getMilestones()) {
            if (m.getStatus().isAllowObjectModification()) continue;
            return false;
        }
        return true;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Deprecated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.ITERATION, this.getId());
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public void migrateTestPlan(CampaignLibrary campaignLibrary) {
        this.testPlan.setCampaignLibrary(campaignLibrary);
    }
}

