/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverviewStatus;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class ExploratorySessionOverview
implements Identified,
AttachmentHolder {
    @Id
    @Column(name="OVERVIEW_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="exploratory_session_overview_overview_id_seq")
    @SequenceGenerator(name="exploratory_session_overview_overview_id_seq", sequenceName="exploratory_session_overview_overview_id_seq", allocationSize=1)
    private Long id;
    @OneToOne(mappedBy="exploratorySessionOverview", cascade={CascadeType.REMOVE, CascadeType.PERSIST})
    private TestPlanItem testPlanItem;
    @Lob
    @JdbcTypeCode(value=-1)
    private String charter;
    @Column
    private Integer sessionDuration;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String reference = "";
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDate;
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String sessionStatus = "TO_DO";
    @Lob
    @JdbcTypeCode(value=-1)
    private String comments;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID", updatable=false)
    private final AttachmentList attachmentList = new AttachmentList();

    public ExploratorySessionOverview() {
    }

    public ExploratorySessionOverview(ExploratoryTestCase testCase, TestPlanItem testPlanItem) {
        this.charter = testCase.getCharter();
        this.sessionDuration = testCase.getSessionDuration();
        this.name = testCase.getName();
        this.reference = testCase.getReference();
        this.setTestPlanItem(testPlanItem);
        testPlanItem.setExploratorySessionOverview(this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public TestPlanItem getTestPlanItem() {
        return this.testPlanItem;
    }

    public void setTestPlanItem(TestPlanItem testPlanItem) {
        this.testPlanItem = testPlanItem;
    }

    public String getCharter() {
        return this.charter;
    }

    public void setCharter(String charter) {
        this.charter = charter;
    }

    public Integer getSessionDuration() {
        return this.sessionDuration;
    }

    public void setUnsafeSessionDuration(Integer sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void updateSessionDuration(Integer sessionDuration) {
        if (sessionDuration == 0) {
            sessionDuration = null;
        }
        this.sessionDuration = sessionDuration;
        this.updateOwnerLastModification();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setUnsafeDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void updateDueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.updateOwnerLastModification();
    }

    public String getSessionStatus() {
        return this.sessionStatus;
    }

    public void setUnsafeSessionStatus(String sessionStatus) {
        this.sessionStatus = sessionStatus;
    }

    public void startSession(User user) {
        this.updateSessionStatus(ExploratorySessionOverviewStatus.RUNNING);
        this.testPlanItem.applyFastPass(ExecutionStatus.RUNNING, user);
    }

    public void endSession() {
        this.updateSessionStatus(ExploratorySessionOverviewStatus.FINISHED);
    }

    private void updateSessionStatus(ExploratorySessionOverviewStatus sessionStatus) {
        this.sessionStatus = sessionStatus.name();
        this.updateOwnerLastModification();
    }

    public String getComments() {
        return this.comments;
    }

    public void setUnsafeComments(String comments) {
        this.comments = comments;
    }

    public void updateComments(String comments) {
        this.comments = comments;
        this.updateOwnerLastModification();
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.testPlanItem.getProject().getId();
    }

    public ExploratorySessionOverview createCopy() {
        ExploratorySessionOverview copy = new ExploratorySessionOverview();
        copy.setCharter(this.charter);
        copy.sessionDuration = this.sessionDuration;
        copy.setName(this.name);
        copy.setReference(this.reference);
        copy.dueDate = this.dueDate;
        copy.sessionStatus = this.sessionStatus;
        copy.comments = this.comments;
        for (Attachment tcAttach : this.getAttachmentList().getAllAttachments()) {
            Attachment clone = tcAttach.shallowCopy();
            copy.getAttachmentList().addAttachment(clone);
        }
        return copy;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.EXPLORATORY_SESSION_OVERVIEW, this.id);
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.testPlanItem.getCampaignLibrary();
    }

    private void updateOwnerLastModification() {
        this.testPlanItem.updateLastModificationWithCurrentUser();
    }
}

