/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;

final class CascadingAutoDateComparatorBuilder {
    private CascadingAutoDateComparatorBuilder() {
    }

    public static Comparator<TestPlanItem> buildTestPlanFirstDateSorter() {
        return (o1, o2) -> {
            Date d1 = o1.getLastExecutedOn();
            Date d2 = o2.getLastExecutedOn();
            return new NullSafeLowerDateComparator().compare(d1, d2);
        };
    }

    public static Comparator<TestPlanItem> buildTestPlanLastDateSorter() {
        return (o1, o2) -> {
            Date d1 = o1.getLastExecutedOn();
            Date d2 = o2.getLastExecutedOn();
            return new NullSafeHigherDateComparator().compare(d1, d2);
        };
    }

    public static Comparator<Iteration> buildIterationActualStartOrder() {
        return (o1, o2) -> {
            Date d1 = o1.getActualStartDate();
            Date d2 = o2.getActualStartDate();
            return new NullSafeLowerDateComparator().compare(d1, d2);
        };
    }

    public static Comparator<Iteration> buildIterationActualEndOrder() {
        return (o1, o2) -> {
            Date d1 = o1.getActualEndDate();
            Date d2 = o2.getActualEndDate();
            return new NullSafeHigherDateComparator().compare(d1, d2);
        };
    }

    private static class NullSafeHigherDateComparator
    implements Comparator<Date>,
    Serializable {
        private static final long serialVersionUID = 4603000444595072281L;

        private NullSafeHigherDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            int result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            return result;
        }
    }

    private static class NullSafeLowerDateComparator
    implements Comparator<Date> {
        private NullSafeLowerDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            int result = o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : o1.compareTo(o2));
            return result;
        }
    }
}

